/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AMRMClientAsync<T extends AMRMClient.ContainerRequest>
extends AbstractService {
    protected final AMRMClient<T> client;
    protected final CallbackHandler handler;
    protected final AtomicInteger heartbeatIntervalMs = new AtomicInteger();

    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(int intervalMs, CallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl(intervalMs, callbackHandler);
    }

    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(AMRMClient<T> client, int intervalMs, CallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl<T>(client, intervalMs, callbackHandler);
    }

    protected AMRMClientAsync(int intervalMs, CallbackHandler callbackHandler) {
        this(new AMRMClientImpl(), intervalMs, callbackHandler);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected AMRMClientAsync(AMRMClient<T> client, int intervalMs, CallbackHandler callbackHandler) {
        super(AMRMClientAsync.class.getName());
        this.client = client;
        this.heartbeatIntervalMs.set(intervalMs);
        this.handler = callbackHandler;
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatIntervalMs.set(interval);
    }

    public abstract List<? extends Collection<T>> getMatchingRequests(Priority var1, String var2, Resource var3);

    public abstract RegisterApplicationMasterResponse registerApplicationMaster(String var1, int var2, String var3) throws YarnException, IOException;

    public abstract void unregisterApplicationMaster(FinalApplicationStatus var1, String var2, String var3) throws YarnException, IOException;

    public abstract void addContainerRequest(T var1);

    public abstract void removeContainerRequest(T var1);

    public abstract void releaseAssignedContainer(ContainerId var1);

    public abstract Resource getAvailableResources();

    public abstract int getClusterNodeCount();

    public static interface CallbackHandler {
        public void onContainersCompleted(List<ContainerStatus> var1);

        public void onContainersAllocated(List<Container> var1);

        public void onShutdownRequest();

        public void onNodesUpdated(List<NodeReport> var1);

        public float getProgress();

        public void onError(Throwable var1);
    }
}

