/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.results;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;

@PublicEvolving
public class ResultSet {
    private final ResultType resultType;
    @Nullable
    private final Long nextToken;
    private final ResolvedSchema resultSchema;
    private final List<RowData> data;
    public static final ResultSet NOT_READY_RESULTS = new ResultSet(ResultType.NOT_READY, 0L, ResolvedSchema.of(Collections.emptyList()), Collections.emptyList());

    public ResultSet(ResultType resultType, @Nullable Long nextToken, ResolvedSchema resultSchema, List<RowData> data) {
        this.nextToken = nextToken;
        this.resultType = resultType;
        this.resultSchema = resultSchema;
        this.data = data;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    @Nullable
    public Long getNextToken() {
        return this.nextToken;
    }

    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    public List<RowData> getData() {
        return this.data;
    }

    public String toString() {
        return String.format("ResultSet{\n  resultType=%s,\n  nextToken=%s,\n  resultSchema=%s,\n  data=[%s]\n}", new Object[]{this.resultType, this.nextToken, this.resultSchema.toString(), this.data.stream().map(Object::toString).collect(Collectors.joining(","))});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultSet)) {
            return false;
        }
        ResultSet resultSet = (ResultSet)o;
        return this.resultType == resultSet.resultType && Objects.equals(this.nextToken, resultSet.nextToken) && Objects.equals(this.resultSchema, resultSet.resultSchema) && Objects.equals(this.data, resultSet.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resultType, this.nextToken, this.resultSchema, this.data});
    }

    @PublicEvolving
    public static enum ResultType {
        NOT_READY,
        PAYLOAD,
        EOS;

    }
}

