/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.statement;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.header.statement.FetchResultsHeaders;
import org.apache.flink.table.gateway.rest.message.operation.OperationHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsTokenParameters;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsTokenPathParameter;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class FetchResultsHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, FetchResultsResponseBody, FetchResultsTokenParameters> {
    public FetchResultsHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, FetchResultsResponseBody, FetchResultsTokenParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<FetchResultsResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) {
        String resultType;
        Long nextToken;
        ResultSet resultSet;
        SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
        OperationHandle operationHandle = (OperationHandle)request.getPathParameter(OperationHandleIdPathParameter.class);
        Long token = (Long)request.getPathParameter(FetchResultsTokenPathParameter.class);
        try {
            resultSet = this.service.fetchResults(sessionHandle, operationHandle, token, Integer.MAX_VALUE);
            nextToken = resultSet.getNextToken();
            resultType = resultSet.getResultType().toString();
        }
        catch (Exception e) {
            throw new SqlGatewayException(e);
        }
        String nextResultUri = FetchResultsHeaders.buildNextUri(version.name().toLowerCase(), sessionHandle.getIdentifier().toString(), operationHandle.getIdentifier().toString(), nextToken);
        return CompletableFuture.completedFuture(new FetchResultsResponseBody(ResultInfo.createResultInfo(resultSet), resultType, nextResultUri));
    }
}

