/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class ResultInfo {
    public static final String FIELD_NAME_COLUMN_INFOS = "columns";
    public static final String FIELD_NAME_DATA = "data";
    public static final String FIELD_NAME_KIND = "kind";
    public static final String FIELD_NAME_FIELDS = "fields";
    private final List<ColumnInfo> columnInfos;
    private final List<RowData> data;

    public ResultInfo(List<ColumnInfo> columnInfos, List<RowData> data) {
        this.columnInfos = columnInfos;
        this.data = data;
    }

    public static ResultInfo createResultInfo(ResultSet resultSet) {
        return new ResultInfo(resultSet.getResultSchema().getColumns().stream().map(ColumnInfo::toColumnInfo).collect(Collectors.toList()), resultSet.getData());
    }

    public List<ColumnInfo> getColumnInfos() {
        return Collections.unmodifiableList(this.columnInfos);
    }

    public List<RowData> getData() {
        return this.data;
    }

    public List<RowData.FieldGetter> getFieldGetters() {
        List columnTypes = this.columnInfos.stream().map(ColumnInfo::getLogicalType).collect(Collectors.toList());
        return IntStream.range(0, columnTypes.size()).mapToObj(i -> RowData.createFieldGetter((LogicalType)((LogicalType)columnTypes.get(i)), (int)i)).collect(Collectors.toList());
    }

    public ResolvedSchema getResultSchema() {
        return ResolvedSchema.of(this.columnInfos.stream().map(ColumnInfo::toColumn).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.columnInfos, this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultInfo)) {
            return false;
        }
        ResultInfo that = (ResultInfo)o;
        return Objects.equals(this.columnInfos, that.columnInfos) && Objects.equals(this.data, that.data);
    }

    public String toString() {
        return String.format("ResultInfo{\n  columnInfos=[%s],\n  rows=[%s]\n}", this.columnInfos.stream().map(Object::toString).collect(Collectors.joining(",")), this.data.stream().map(Object::toString).collect(Collectors.joining(",")));
    }
}

