/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CollectionUtil;

@Internal
public class ResultInfoJsonDeserializer
extends StdDeserializer<ResultInfo> {
    private static final long serialVersionUID = 1L;
    private static final JsonToRowDataConverters TO_ROW_DATA_CONVERTERS = new JsonToRowDataConverters(false, false, TimestampFormat.ISO_8601);

    public ResultInfoJsonDeserializer() {
        super(ResultInfo.class);
    }

    public ResultInfo deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        List<Object> columnInfos = Arrays.asList((Object[])jsonParser.getCodec().treeToValue((TreeNode)node.get("columns"), ColumnInfo[].class));
        List<JsonToRowDataConverters.JsonToRowDataConverter> converters = columnInfos.stream().map(ColumnInfo::getLogicalType).map(arg_0 -> ((JsonToRowDataConverters)TO_ROW_DATA_CONVERTERS).createConverter(arg_0)).collect(Collectors.toList());
        List<RowData> data = this.deserializeData((ArrayNode)node.get("data"), converters);
        return new ResultInfo(columnInfos, data);
    }

    private List<RowData> deserializeData(ArrayNode serializedRows, List<JsonToRowDataConverters.JsonToRowDataConverter> converters) {
        ArrayList<RowData> data = new ArrayList<RowData>();
        serializedRows.forEach(rowDataNode -> data.add((RowData)this.convertToRowData((JsonNode)rowDataNode, converters)));
        return data;
    }

    private GenericRowData convertToRowData(JsonNode serializedRow, List<JsonToRowDataConverters.JsonToRowDataConverter> converters) {
        ArrayNode fieldsArrayNode = (ArrayNode)serializedRow.get("fields");
        List fieldNodes = CollectionUtil.iteratorToList((Iterator)fieldsArrayNode.iterator());
        return GenericRowData.ofKind((RowKind)RowKind.valueOf((String)serializedRow.get("kind").asText()), (Object[])IntStream.range(0, fieldNodes.size()).mapToObj(i -> ((JsonToRowDataConverters.JsonToRowDataConverter)converters.get(i)).convert((JsonNode)fieldNodes.get(i))).toArray());
    }
}

