/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;

@Internal
public class ResultInfoJsonSerializer
extends StdSerializer<ResultInfo> {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final RowDataToJsonConverters TO_JSON_CONVERTERS = new RowDataToJsonConverters(TimestampFormat.ISO_8601, JsonFormatOptions.MapNullKeyMode.LITERAL, "");

    public ResultInfoJsonSerializer() {
        super(ResultInfo.class);
    }

    public void serialize(ResultInfo resultInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        serializerProvider.defaultSerializeField("columns", resultInfo.getColumnInfos(), jsonGenerator);
        this.serializeData(resultInfo.getData(), this.buildToJsonConverters(resultInfo), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void serializeData(List<RowData> data, List<Function<RowData, JsonNode>> converters, JsonGenerator jsonGenerator) throws IOException {
        ArrayNode serializedData = OBJECT_MAPPER.createArrayNode();
        serializedData.addAll((Collection)data.stream().map(rowData -> this.convertRowData((RowData)rowData, converters)).collect(Collectors.toList()));
        jsonGenerator.writeFieldName("data");
        jsonGenerator.writeTree((TreeNode)serializedData);
    }

    private JsonNode convertRowData(RowData rowData, List<Function<RowData, JsonNode>> converters) {
        ObjectNode serializedRowData = OBJECT_MAPPER.createObjectNode();
        serializedRowData.put("kind", rowData.getRowKind().name());
        ArrayNode fields = serializedRowData.putArray("fields");
        fields.addAll((Collection)converters.stream().map(converter -> (JsonNode)converter.apply(rowData)).collect(Collectors.toList()));
        return serializedRowData;
    }

    private List<Function<RowData, JsonNode>> buildToJsonConverters(ResultInfo resultInfo) {
        List converters = resultInfo.getColumnInfos().stream().map(ColumnInfo::getLogicalType).map(arg_0 -> ((RowDataToJsonConverters)TO_JSON_CONVERTERS).createConverter(arg_0)).collect(Collectors.toList());
        List<RowData.FieldGetter> fieldGetters = resultInfo.getFieldGetters();
        return IntStream.range(0, converters.size()).mapToObj(i -> rowData -> ((RowDataToJsonConverters.RowDataToJsonConverter)converters.get(i)).convert(OBJECT_MAPPER, null, ((RowData.FieldGetter)fieldGetters.get(i)).getFieldOrNull(rowData))).collect(Collectors.toList());
    }
}

