/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.operation;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FunctionInfo;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.results.TableInfo;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.StopJobOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.table.operations.ddl.DropOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OperationExecutor.class);
    private final SessionContext sessionContext;
    private final Configuration executionConfig;
    private final ClusterClientServiceLoader clusterClientServiceLoader;

    @VisibleForTesting
    public OperationExecutor(SessionContext context, Configuration executionConfig) {
        this.sessionContext = context;
        this.executionConfig = executionConfig;
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }

    public ResultFetcher configureSession(OperationHandle handle, String statement) {
        TableEnvironmentInternal tableEnv = this.getTableEnvironment();
        List parsedOperations = tableEnv.getParser().parse(statement);
        if (parsedOperations.size() > 1) {
            throw new UnsupportedOperationException("Unsupported SQL statement! Configure session only accepts a single SQL statement.");
        }
        Operation op = (Operation)parsedOperations.get(0);
        if (!(op instanceof SetOperation || op instanceof ResetOperation || op instanceof CreateOperation || op instanceof DropOperation || op instanceof UseOperation || op instanceof AlterOperation || op instanceof LoadModuleOperation || op instanceof UnloadModuleOperation || op instanceof AddJarOperation)) {
            throw new UnsupportedOperationException(String.format("Unsupported statement for configuring session:%s\nThe configureSession API only supports to execute statement of type CREATE TABLE, DROP TABLE, ALTER TABLE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, USE CATALOG, USE [CATALOG.]DATABASE, CREATE VIEW, DROP VIEW, LOAD MODULE, UNLOAD MODULE, USE MODULE, ADD JAR.", statement));
        }
        if (op instanceof SetOperation) {
            return this.callSetOperation(tableEnv, handle, (SetOperation)op);
        }
        if (op instanceof ResetOperation) {
            return this.callResetOperation(handle, (ResetOperation)op);
        }
        return this.callOperation(tableEnv, handle, op);
    }

    public ResultFetcher executeStatement(OperationHandle handle, String statement) {
        TableEnvironmentInternal tableEnv = this.getTableEnvironment();
        List parsedOperations = tableEnv.getParser().parse(statement);
        if (parsedOperations.size() > 1) {
            throw new UnsupportedOperationException("Unsupported SQL statement! Execute statement only accepts a single SQL statement or multiple 'INSERT INTO' statements wrapped in a 'STATEMENT SET' block.");
        }
        Operation op = (Operation)parsedOperations.get(0);
        return this.sessionContext.isStatementSetState() ? this.executeOperationInStatementSetState(tableEnv, handle, op) : this.executeOperation(tableEnv, handle, op);
    }

    public String getCurrentCatalog() {
        return this.sessionContext.getSessionState().catalogManager.getCurrentCatalog();
    }

    public Set<String> listCatalogs() {
        return this.sessionContext.getSessionState().catalogManager.listCatalogs();
    }

    public Set<String> listDatabases(String catalogName) {
        return new HashSet<String>(((Catalog)this.sessionContext.getSessionState().catalogManager.getCatalog(catalogName).orElseThrow(() -> new CatalogNotExistException(String.format("Catalog '%s' does not exist.", catalogName)))).listDatabases());
    }

    public Set<TableInfo> listTables(String catalogName, String databaseName, Set<CatalogBaseTable.TableKind> tableKinds) {
        Preconditions.checkArgument((boolean)Arrays.asList(CatalogBaseTable.TableKind.TABLE, CatalogBaseTable.TableKind.VIEW).containsAll(tableKinds), (Object)"Currently only support to list TABLE, VIEW or TABLE AND VIEW.");
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE) && tableKinds.contains(CatalogBaseTable.TableKind.VIEW)) {
            return this.listTables(catalogName, databaseName, true);
        }
        if (tableKinds.contains(CatalogBaseTable.TableKind.TABLE)) {
            return this.listTables(catalogName, databaseName, false);
        }
        return this.listViews(catalogName, databaseName);
    }

    public ResolvedCatalogBaseTable<?> getTable(ObjectIdentifier tableIdentifier) {
        return this.getTableEnvironment().getCatalogManager().getTableOrError(tableIdentifier).getResolvedTable();
    }

    public Set<FunctionInfo> listUserDefinedFunctions(String catalogName, String databaseName) {
        return this.sessionContext.getSessionState().functionCatalog.getUserDefinedFunctions(catalogName, databaseName).stream().map(FunctionInfo::new).collect(Collectors.toSet());
    }

    public Set<FunctionInfo> listSystemFunctions() {
        HashSet<FunctionInfo> info = new HashSet<FunctionInfo>();
        for (String functionName : this.sessionContext.getSessionState().moduleManager.listFunctions()) {
            try {
                info.add(this.sessionContext.getSessionState().moduleManager.getFunctionDefinition(functionName).map(definition -> new FunctionInfo(FunctionIdentifier.of((String)functionName), definition.getKind())).orElse(new FunctionInfo(FunctionIdentifier.of((String)functionName))));
            }
            catch (Throwable t) {
                LOG.error(String.format("Failed to load the system function `%s`.", functionName), t);
            }
        }
        return info;
    }

    public FunctionDefinition getFunctionDefinition(UnresolvedIdentifier identifier) {
        return ((ContextResolvedFunction)this.sessionContext.getSessionState().functionCatalog.lookupFunction(identifier).orElseThrow(() -> new IllegalArgumentException(String.format("Can not find the definition: %s.", identifier.asSummaryString())))).getDefinition();
    }

    public ResultSet getCompletionHints(String statement, int position) {
        return new ResultSet(ResultSet.ResultType.EOS, null, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"candidates", (DataType)DataTypes.STRING())}), Arrays.stream(this.getTableEnvironment().getParser().getCompletionHints(statement, position)).map(hint -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)hint)})).collect(Collectors.toList()));
    }

    @VisibleForTesting
    public TableEnvironmentInternal getTableEnvironment() {
        TableEnvironmentInternal tableEnv = this.sessionContext.createTableEnvironment();
        tableEnv.getConfig().getConfiguration().addAll(this.executionConfig);
        return tableEnv;
    }

    private ResultFetcher executeOperationInStatementSetState(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation operation) {
        if (operation instanceof EndStatementSetOperation) {
            return this.callEndStatementSetOperation(tableEnv, handle);
        }
        if (operation instanceof ModifyOperation) {
            this.sessionContext.addStatementSetOperation((ModifyOperation)operation);
            return this.buildOkResultFetcher(handle);
        }
        throw new SqlExecutionException("Only 'INSERT/CREATE TABLE AS' statement is allowed in Statement Set or use 'END' statement to submit Statement Set.");
    }

    private ResultFetcher executeOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation op) {
        if (op instanceof SetOperation) {
            return this.callSetOperation(tableEnv, handle, (SetOperation)op);
        }
        if (op instanceof ResetOperation) {
            return this.callResetOperation(handle, (ResetOperation)op);
        }
        if (op instanceof BeginStatementSetOperation) {
            return this.callBeginStatementSetOperation(handle);
        }
        if (op instanceof EndStatementSetOperation) {
            throw new SqlExecutionException("No Statement Set to submit. 'END' statement should be used after 'BEGIN STATEMENT SET'.");
        }
        if (op instanceof ModifyOperation) {
            return this.callModifyOperations(tableEnv, handle, Collections.singletonList((ModifyOperation)op));
        }
        if (op instanceof StatementSetOperation) {
            return this.callModifyOperations(tableEnv, handle, ((StatementSetOperation)op).getOperations());
        }
        if (op instanceof QueryOperation) {
            TableResultInternal result = tableEnv.executeInternal(op);
            return new ResultFetcher(handle, result.getResolvedSchema(), (CloseableIterator<RowData>)result.collectInternal());
        }
        if (op instanceof StopJobOperation) {
            return this.callStopJobOperation(handle, (StopJobOperation)op);
        }
        return this.callOperation(tableEnv, handle, op);
    }

    private ResultFetcher callSetOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, SetOperation setOp) {
        if (setOp.getKey().isPresent() && setOp.getValue().isPresent()) {
            this.sessionContext.set(((String)setOp.getKey().get()).trim(), ((String)setOp.getValue().get()).trim());
            return this.buildOkResultFetcher(handle);
        }
        if (!setOp.getKey().isPresent() && !setOp.getValue().isPresent()) {
            Map configMap = tableEnv.getConfig().getConfiguration().toMap();
            return new ResultFetcher(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}), CollectionUtil.iteratorToList(configMap.entrySet().stream().map(entry -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)((String)entry.getKey())), StringData.fromString((String)((String)entry.getValue()))})).map(RowData.class::cast).iterator()));
        }
        throw new SqlExecutionException("Illegal SetOperation: " + setOp.asSummaryString());
    }

    private ResultFetcher callResetOperation(OperationHandle handle, ResetOperation resetOp) {
        if (resetOp.getKey().isPresent()) {
            this.sessionContext.reset(((String)resetOp.getKey().get()).trim());
        } else {
            this.sessionContext.reset();
        }
        return this.buildOkResultFetcher(handle);
    }

    private ResultFetcher callBeginStatementSetOperation(OperationHandle handle) {
        this.sessionContext.enableStatementSet();
        return this.buildOkResultFetcher(handle);
    }

    private ResultFetcher callEndStatementSetOperation(TableEnvironmentInternal tableEnv, OperationHandle handle) {
        List<ModifyOperation> statementSetOperations = this.sessionContext.getStatementSetOperations();
        this.sessionContext.disableStatementSet();
        if (statementSetOperations.isEmpty()) {
            return this.buildOkResultFetcher(handle);
        }
        return this.callModifyOperations(tableEnv, handle, statementSetOperations);
    }

    private ResultFetcher callModifyOperations(TableEnvironmentInternal tableEnv, OperationHandle handle, List<ModifyOperation> modifyOperations) {
        TableResultInternal result = tableEnv.executeInternal(modifyOperations);
        return new ResultFetcher(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"job id", (DataType)DataTypes.STRING())}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)((JobClient)result.getJobClient().orElseThrow(() -> new SqlExecutionException(String.format("Can't get job client for the operation %s.", handle)))).getJobID().toString())})));
    }

    private ResultFetcher callOperation(TableEnvironmentInternal tableEnv, OperationHandle handle, Operation op) {
        TableResultInternal result = tableEnv.executeInternal(op);
        return new ResultFetcher(handle, result.getResolvedSchema(), CollectionUtil.iteratorToList((Iterator)result.collectInternal()));
    }

    private Set<TableInfo> listTables(String catalogName, String databaseName, boolean includeViews) {
        CatalogManager catalogManager = this.sessionContext.getSessionState().catalogManager;
        HashMap views = new HashMap();
        catalogManager.listViews(catalogName, databaseName).forEach(name -> views.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)));
        HashMap ans = new HashMap();
        if (includeViews) {
            ans.putAll(views);
        }
        catalogManager.listTables(catalogName, databaseName).stream().filter(name -> !views.containsKey(name)).forEach(name -> ans.put(name, new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.TABLE)));
        return Collections.unmodifiableSet(new HashSet(ans.values()));
    }

    private Set<TableInfo> listViews(String catalogName, String databaseName) {
        return Collections.unmodifiableSet(this.sessionContext.getSessionState().catalogManager.listViews(catalogName, databaseName).stream().map(name -> new TableInfo(ObjectIdentifier.of((String)catalogName, (String)databaseName, (String)name), CatalogBaseTable.TableKind.VIEW)).collect(Collectors.toSet()));
    }

    public ResultFetcher callStopJobOperation(OperationHandle handle, StopJobOperation stopJobOperation) throws SqlExecutionException {
        Optional savepoint;
        String jobId = stopJobOperation.getJobId();
        boolean isWithSavepoint = stopJobOperation.isWithSavepoint();
        boolean isWithDrain = stopJobOperation.isWithDrain();
        Duration clientTimeout = (Duration)Configuration.fromMap(this.sessionContext.getConfigMap()).get(ClientOptions.CLIENT_TIMEOUT);
        try {
            savepoint = this.runClusterAction(handle, clusterClient -> {
                if (isWithSavepoint) {
                    try {
                        return Optional.of(clusterClient.stopWithSavepoint(JobID.fromHexString((String)jobId), isWithDrain, (String)this.executionConfig.get(CheckpointingOptions.SAVEPOINT_DIRECTORY), SavepointFormatType.DEFAULT).get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS));
                    }
                    catch (Exception e) {
                        throw new FlinkException("Could not stop job " + stopJobOperation.getJobId() + " in session " + handle.getIdentifier() + ".", (Throwable)e);
                    }
                }
                clusterClient.cancel(JobID.fromHexString((String)jobId));
                return Optional.empty();
            });
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not stop job " + jobId + " for operation " + handle + ".", e);
        }
        if (isWithSavepoint) {
            return new ResultFetcher(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"savepoint_path", (DataType)DataTypes.STRING())}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)savepoint.orElse(""))})));
        }
        return this.buildOkResultFetcher(handle);
    }

    private ResultFetcher buildOkResultFetcher(OperationHandle handle) {
        return new ResultFetcher(handle, TableResultInternal.TABLE_RESULT_OK.getResolvedSchema(), CollectionUtil.iteratorToList((Iterator)TableResultInternal.TABLE_RESULT_OK.collectInternal()));
    }

    /*
     * Exception decompiling
     */
    private <ClusterID, Result> Result runClusterAction(OperationHandle handle, ClusterAction<ClusterID, Result> clusterAction) throws FlinkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface ClusterAction<ClusterID, Result> {
        public Result runAction(ClusterClient<ClusterID> var1) throws FlinkException;
    }
}

