/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.util.StringUtils;

@Internal
public class BufferSpiller {
    private static final AtomicInteger DIRECTORY_INDEX = new AtomicInteger(0);
    private static final int READ_BUFFER_SIZE = 0x100000;
    private final File tempDir;
    private final String spillFilePrefix;
    private final ByteBuffer readBuffer;
    private final ByteBuffer headBuffer;
    private final ByteBuffer[] sources;
    private File currentSpillFile;
    private FileChannel currentChannel;
    private final int pageSize;
    private int fileCounter;
    private boolean hasWritten;

    public BufferSpiller(IOManager ioManager, int pageSize) throws IOException {
        this.pageSize = pageSize;
        this.readBuffer = ByteBuffer.allocateDirect(0x100000);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.headBuffer = ByteBuffer.allocateDirect(16);
        this.headBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.sources = new ByteBuffer[]{this.headBuffer, null};
        File[] tempDirs = ioManager.getSpillingDirectories();
        this.tempDir = tempDirs[DIRECTORY_INDEX.getAndIncrement() % tempDirs.length];
        byte[] rndBytes = new byte[32];
        new Random().nextBytes(rndBytes);
        this.spillFilePrefix = StringUtils.byteToHexString((byte[])rndBytes) + '.';
        this.createSpillingChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BufferOrEvent boe) throws IOException {
        this.hasWritten = true;
        try {
            ByteBuffer contents;
            if (boe.isBuffer()) {
                Buffer buf = boe.getBuffer();
                contents = buf.getMemorySegment().wrap(0, buf.getSize());
            } else {
                contents = EventSerializer.toSerializedEvent((AbstractEvent)boe.getEvent());
            }
            this.headBuffer.clear();
            this.headBuffer.putInt(boe.getChannelIndex());
            this.headBuffer.putInt(contents.remaining());
            this.headBuffer.put((byte)(!boe.isBuffer() ? 1 : 0));
            this.headBuffer.flip();
            this.sources[1] = contents;
            this.currentChannel.write(this.sources);
        }
        finally {
            if (boe.isBuffer()) {
                boe.getBuffer().recycle();
            }
        }
    }

    public SpilledBufferOrEventSequence rollOver() throws IOException {
        return this.rollOverInternal(false);
    }

    public SpilledBufferOrEventSequence rollOverWithNewBuffer() throws IOException {
        return this.rollOverInternal(true);
    }

    private SpilledBufferOrEventSequence rollOverInternal(boolean newBuffer) throws IOException {
        ByteBuffer buf;
        if (!this.hasWritten) {
            return null;
        }
        if (newBuffer) {
            buf = ByteBuffer.allocateDirect(0x100000);
            buf.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buf = this.readBuffer;
        }
        this.currentChannel.position(0L);
        SpilledBufferOrEventSequence seq = new SpilledBufferOrEventSequence(this.currentSpillFile, this.currentChannel, buf, this.pageSize);
        this.createSpillingChannel();
        this.hasWritten = false;
        return seq;
    }

    public void close() throws IOException {
        this.currentChannel.close();
        if (!this.currentSpillFile.delete()) {
            throw new IOException("Cannot delete spill file");
        }
    }

    File getCurrentSpillFile() {
        return this.currentSpillFile;
    }

    FileChannel getCurrentChannel() {
        return this.currentChannel;
    }

    private void createSpillingChannel() throws IOException {
        this.currentSpillFile = new File(this.tempDir, this.spillFilePrefix + this.fileCounter++ + ".buffer");
        this.currentChannel = new RandomAccessFile(this.currentSpillFile, "rw").getChannel();
    }

    public static class SpilledBufferOrEventSequence {
        private static final int HEADER_LENGTH = 9;
        private final File file;
        private final FileChannel fileChannel;
        private final ByteBuffer buffer;
        private final int pageSize;
        private boolean opened = false;

        SpilledBufferOrEventSequence(File file, FileChannel fileChannel, ByteBuffer buffer, int pageSize) {
            this.file = file;
            this.fileChannel = fileChannel;
            this.buffer = buffer;
            this.pageSize = pageSize;
        }

        public void open() {
            if (!this.opened) {
                this.opened = true;
                this.buffer.position(0);
                this.buffer.limit(0);
            }
        }

        public BufferOrEvent getNext() throws IOException {
            boolean isBuffer;
            if (this.buffer.remaining() < 9) {
                this.buffer.compact();
                while (this.buffer.position() < 9) {
                    if (this.fileChannel.read(this.buffer) != -1) continue;
                    if (this.buffer.position() == 0) {
                        return null;
                    }
                    throw new IOException("Found trailing incomplete buffer or event");
                }
                this.buffer.flip();
            }
            int channel = this.buffer.getInt();
            int length = this.buffer.getInt();
            boolean bl = isBuffer = this.buffer.get() == 0;
            if (isBuffer) {
                if (length > this.pageSize) {
                    throw new IOException(String.format("Spilled buffer (%d bytes) is larger than page size of (%d bytes)", length, this.pageSize));
                }
                MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)this.pageSize);
                int segPos = 0;
                int bytesRemaining = length;
                while (true) {
                    int toCopy;
                    if ((toCopy = Math.min(this.buffer.remaining(), bytesRemaining)) > 0) {
                        seg.put(segPos, this.buffer, toCopy);
                        segPos += toCopy;
                        bytesRemaining -= toCopy;
                    }
                    if (bytesRemaining == 0) break;
                    this.buffer.clear();
                    if (this.fileChannel.read(this.buffer) == -1) {
                        throw new IOException("Found trailing incomplete buffer");
                    }
                    this.buffer.flip();
                }
                Buffer buf = new Buffer(seg, FreeingBufferRecycler.INSTANCE);
                buf.setSize(length);
                return new BufferOrEvent(buf, channel);
            }
            if (length > this.buffer.capacity() - 9) {
                throw new IOException("Event is too large");
            }
            if (this.buffer.remaining() < length) {
                this.buffer.compact();
                while (this.buffer.position() < length) {
                    if (this.fileChannel.read(this.buffer) != -1) continue;
                    throw new IOException("Found trailing incomplete event");
                }
                this.buffer.flip();
            }
            int oldLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + length);
            AbstractEvent evt = EventSerializer.fromSerializedEvent((ByteBuffer)this.buffer, (ClassLoader)this.getClass().getClassLoader());
            this.buffer.limit(oldLimit);
            return new BufferOrEvent(evt, channel);
        }

        public void cleanup() throws IOException {
            this.fileChannel.close();
            if (!this.file.delete()) {
                throw new IOException("Cannot remove temp file for stream alignment writer");
            }
        }
    }
}

