/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.streaming.runtime.tasks.TimeServiceProvider;

public class TestTimeServiceProvider
extends TimeServiceProvider {
    private long currentTime = 0L;
    private Map<Long, List<Runnable>> registeredTasks = new HashMap<Long, List<Runnable>>();

    public void setCurrentTime(long timestamp) {
        this.currentTime = timestamp;
        Iterator<Map.Entry<Long, List<Runnable>>> it = this.registeredTasks.entrySet().iterator();
        ArrayList<Runnable> toRun = new ArrayList<Runnable>();
        while (it.hasNext()) {
            Map.Entry<Long, List<Runnable>> t = it.next();
            if (t.getKey() > this.currentTime) continue;
            for (Runnable r : t.getValue()) {
                toRun.add(r);
            }
            it.remove();
        }
        for (Runnable r : toRun) {
            r.run();
        }
    }

    @Override
    public long getCurrentProcessingTime() {
        return this.currentTime;
    }

    @Override
    public ScheduledFuture<?> registerTimer(long timestamp, Runnable target) {
        List<Runnable> tasks = this.registeredTasks.get(timestamp);
        if (tasks == null) {
            tasks = new ArrayList<Runnable>();
            this.registeredTasks.put(timestamp, tasks);
        }
        tasks.add(target);
        return null;
    }

    public int getNoOfRegisteredTimers() {
        int count = 0;
        for (List<Runnable> tasks : this.registeredTasks.values()) {
            count += tasks.size();
        }
        return count;
    }

    @Override
    public void shutdownService() throws Exception {
        this.registeredTasks.clear();
        this.registeredTasks = null;
    }
}

