/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.Beta;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.AbstractIterator;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    private Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T or(Supplier<? extends T> var1);

    @Nullable
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T> Iterable<T> presentInstances(final Iterable<Optional<T>> optionals) {
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<Optional<T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Absent
    extends Optional<Object> {
        private static final Absent INSTANCE = new Absent();
        private static final long serialVersionUID = 0L;

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("value is absent");
        }

        @Override
        public Object or(Object defaultValue) {
            return Preconditions.checkNotNull(defaultValue, "use orNull() instead of or(null)");
        }

        @Override
        public Optional<Object> or(Optional<?> secondChoice) {
            return Preconditions.checkNotNull(secondChoice);
        }

        @Override
        public Object or(Supplier<?> supplier) {
            return Preconditions.checkNotNull(supplier.get(), "use orNull() instead of a Supplier that returns null");
        }

        @Override
        @Nullable
        public Object orNull() {
            return null;
        }

        @Override
        public Set<Object> asSet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return object == this;
        }

        @Override
        public int hashCode() {
            return 1502476572;
        }

        @Override
        public String toString() {
            return "Optional.absent()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Present<T>
    extends Optional<T> {
        private final T reference;
        private static final long serialVersionUID = 0L;

        Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public T or(T defaultValue) {
            Preconditions.checkNotNull(defaultValue, "use orNull() instead of or(null)");
            return this.reference;
        }

        @Override
        public Optional<T> or(Optional<? extends T> secondChoice) {
            Preconditions.checkNotNull(secondChoice);
            return this;
        }

        @Override
        public T or(Supplier<? extends T> supplier) {
            Preconditions.checkNotNull(supplier);
            return this.reference;
        }

        @Override
        public T orNull() {
            return this.reference;
        }

        @Override
        public Set<T> asSet() {
            return Collections.singleton(this.reference);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Present) {
                Present other = (Present)object;
                return this.reference.equals(other.reference);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 1502476572 + this.reference.hashCode();
        }

        @Override
        public String toString() {
            return "Optional.of(" + this.reference + ")";
        }
    }
}

