/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto.BouncyCastleProviderSingleton;
import org.apache.flink.fs.openstackhadoop.shaded.net.jcip.annotations.ThreadSafe;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;

@ThreadSafe
class AES {
    public static KeyGenerator createKeyGenerator() throws JOSEException {
        try {
            return KeyGenerator.getInstance("AES", (Provider)BouncyCastleProviderSingleton.getInstance());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static SecretKey generateKey(int keyBitLength, SecureRandom random) throws JOSEException {
        KeyGenerator aesKeyGenerator = AES.createKeyGenerator();
        aesKeyGenerator.init(keyBitLength, random);
        return aesKeyGenerator.generateKey();
    }

    public static AESEngine createCipher(SecretKey secretKey, boolean forEncryption) {
        AESEngine cipher = new AESEngine();
        KeyParameter cipherParams = new KeyParameter(secretKey.getEncoded());
        cipher.init(forEncryption, (CipherParameters)cipherParams);
        return cipher;
    }

    private AES() {
    }
}

