/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto.RSASSAProvider;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.flink.fs.openstackhadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSASigner
extends RSASSAProvider
implements JWSSigner {
    private final RSAPrivateKey privateKey;

    public RSASSASigner(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        Signature signer = RSASSASigner.getRSASignerAndVerifier(header.getAlgorithm(), this.provider);
        try {
            signer.initSign(this.privateKey);
            signer.update(signingInput);
            return Base64URL.encode(signer.sign());
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid private RSA key: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new JOSEException("RSA signature exception: " + e.getMessage(), e);
        }
    }
}

