/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.Algorithm;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk.JWK;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk.JWKSet;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk.KeyOperation;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk.KeyType;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk.KeyUse;

public class JWKSelector {
    private Set<KeyType> types;
    private Set<KeyUse> uses;
    private Set<KeyOperation> ops;
    private Set<Algorithm> algs;
    private Set<String> ids;
    private boolean privateOnly = false;
    private boolean publicOnly = false;

    public Set<KeyType> getKeyTypes() {
        return this.types;
    }

    public void setKeyType(KeyType kty) {
        this.types = kty == null ? null : new HashSet<KeyType>(Arrays.asList(kty));
    }

    public void setKeyTypes(KeyType ... types) {
        this.setKeyTypes(new HashSet<KeyType>(Arrays.asList(types)));
    }

    public void setKeyTypes(Set<KeyType> types) {
        this.types = types;
    }

    public Set<KeyUse> getKeyUses() {
        return this.uses;
    }

    public void setKeyUse(KeyUse use) {
        this.uses = use == null ? null : new HashSet<KeyUse>(Arrays.asList(use));
    }

    public void setKeyUses(KeyUse ... uses) {
        this.setKeyUses(new HashSet<KeyUse>(Arrays.asList(uses)));
    }

    public void setKeyUses(Set<KeyUse> uses) {
        this.uses = uses;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public void setKeyOperation(KeyOperation op) {
        this.ops = op == null ? null : new HashSet<KeyOperation>(Arrays.asList(op));
    }

    public void setKeyOperations(KeyOperation ... ops) {
        this.setKeyOperations(new HashSet<KeyOperation>(Arrays.asList(ops)));
    }

    public void setKeyOperations(Set<KeyOperation> ops) {
        this.ops = ops;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public void setAlgorithm(Algorithm alg) {
        this.algs = alg == null ? null : new HashSet<Algorithm>(Arrays.asList(alg));
    }

    public void setAlgorithms(Algorithm ... algs) {
        this.setAlgorithms(new HashSet<Algorithm>(Arrays.asList(algs)));
    }

    public void setAlgorithms(Set<Algorithm> algs) {
        this.algs = algs;
    }

    public Set<String> getKeyIDs() {
        return this.ids;
    }

    public void setKeyIDs(String ... ids) {
        this.setKeyIDs(new HashSet<String>(Arrays.asList(ids)));
    }

    public void setKeyIDs(Set<String> ids) {
        this.ids = ids;
    }

    public void setKeyID(String id) {
        this.ids = id == null ? null : new HashSet<String>(Arrays.asList(id));
    }

    public boolean isPrivateOnly() {
        return this.privateOnly;
    }

    public void setPrivateOnly(boolean privateOnly) {
        this.privateOnly = privateOnly;
    }

    public boolean isPublicOnly() {
        return this.publicOnly;
    }

    public void setPublicOnly(boolean publicOnly) {
        this.publicOnly = publicOnly;
    }

    public List<JWK> select(JWKSet jwkSet) {
        LinkedList<JWK> matches = new LinkedList<JWK>();
        if (jwkSet == null) {
            return matches;
        }
        for (JWK key : jwkSet.getKeys()) {
            if (this.privateOnly && !key.isPrivate() || this.publicOnly && key.isPrivate() || this.types != null && !this.types.contains(key.getKeyType()) || this.uses != null && !this.uses.contains((Object)key.getKeyUse()) || this.ops != null && (!this.ops.contains(null) || key.getKeyOperations() != null) && (key.getKeyOperations() == null || !this.ops.containsAll(key.getKeyOperations())) || this.algs != null && !this.algs.contains(key.getAlgorithm()) || this.ids != null && !this.ids.contains(key.getKeyID())) continue;
            matches.add(key);
        }
        return matches;
    }
}

