/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.jwk;

import java.text.ParseException;

public enum KeyUse {
    SIGNATURE("sig"),
    ENCRYPTION("enc");

    private final String identifier;

    private KeyUse(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("The key use identifier must not be null");
        }
        this.identifier = identifier;
    }

    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier();
    }

    public static KeyUse parse(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        for (KeyUse use : KeyUse.values()) {
            if (!s.equals(use.identifier)) continue;
            return use;
        }
        throw new ParseException("Invalid JWK use: " + s, 0);
    }
}

