/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp.Authenticator;
import org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp.CertificatePinner;
import org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp.ConnectionSpec;
import org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp.Protocol;
import org.apache.flink.fs.openstackhadoop.shaded.com.squareup.okhttp.internal.Util;

public final class Address {
    final Proxy proxy;
    final String uriHost;
    final int uriPort;
    final SocketFactory socketFactory;
    final SSLSocketFactory sslSocketFactory;
    final HostnameVerifier hostnameVerifier;
    final CertificatePinner certificatePinner;
    final Authenticator authenticator;
    final List<Protocol> protocols;
    final List<ConnectionSpec> connectionSpecs;
    final ProxySelector proxySelector;

    public Address(String uriHost, int uriPort, SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, CertificatePinner certificatePinner, Authenticator authenticator, Proxy proxy, List<Protocol> protocols, List<ConnectionSpec> connectionSpecs, ProxySelector proxySelector) {
        if (uriHost == null) {
            throw new NullPointerException("uriHost == null");
        }
        if (uriPort <= 0) {
            throw new IllegalArgumentException("uriPort <= 0: " + uriPort);
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator == null");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        if (proxySelector == null) {
            throw new IllegalArgumentException("proxySelector == null");
        }
        this.proxy = proxy;
        this.uriHost = uriHost;
        this.uriPort = uriPort;
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.certificatePinner = certificatePinner;
        this.authenticator = authenticator;
        this.protocols = Util.immutableList(protocols);
        this.connectionSpecs = Util.immutableList(connectionSpecs);
        this.proxySelector = proxySelector;
    }

    public String getUriHost() {
        return this.uriHost;
    }

    public int getUriPort() {
        return this.uriPort;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> getConnectionSpecs() {
        return this.connectionSpecs;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public boolean equals(Object other) {
        if (other instanceof Address) {
            Address that = (Address)other;
            return Util.equal(this.proxy, that.proxy) && this.uriHost.equals(that.uriHost) && this.uriPort == that.uriPort && Util.equal(this.sslSocketFactory, that.sslSocketFactory) && Util.equal(this.hostnameVerifier, that.hostnameVerifier) && Util.equal(this.certificatePinner, that.certificatePinner) && Util.equal(this.authenticator, that.authenticator) && Util.equal(this.protocols, that.protocols) && Util.equal(this.connectionSpecs, that.connectionSpecs) && Util.equal(this.proxySelector, that.proxySelector);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + this.uriHost.hashCode();
        result = 31 * result + this.uriPort;
        result = 31 * result + (this.sslSocketFactory != null ? this.sslSocketFactory.hashCode() : 0);
        result = 31 * result + (this.hostnameVerifier != null ? this.hostnameVerifier.hashCode() : 0);
        result = 31 * result + (this.certificatePinner != null ? this.certificatePinner.hashCode() : 0);
        result = 31 * result + this.authenticator.hashCode();
        result = 31 * result + this.protocols.hashCode();
        result = 31 * result + this.connectionSpecs.hashCode();
        result = 31 * result + this.proxySelector.hashCode();
        return result;
    }
}

