/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs;

import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.tracing.TraceUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FsTracer {
    private static Tracer instance;

    public static synchronized Tracer get(Configuration conf) {
        if (instance == null) {
            instance = new Tracer.Builder("FSClient").conf(TraceUtils.wrapHadoopConf("fs.client.htrace.", conf)).build();
        }
        return instance;
    }

    @VisibleForTesting
    public static synchronized void clear() {
        if (instance == null) {
            return;
        }
        try {
            instance.close();
        }
        finally {
            instance = null;
        }
    }

    private FsTracer() {
    }
}

