/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Set;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockPlacementStatusWithNodeGroup
implements BlockPlacementStatus {
    private final BlockPlacementStatus parentBlockPlacementStatus;
    private final Set<String> currentNodeGroups;
    private final int requiredNodeGroups;

    public BlockPlacementStatusWithNodeGroup(BlockPlacementStatus parentBlockPlacementStatus, Set<String> currentNodeGroups, int requiredNodeGroups) {
        this.parentBlockPlacementStatus = parentBlockPlacementStatus;
        this.currentNodeGroups = currentNodeGroups;
        this.requiredNodeGroups = requiredNodeGroups;
    }

    @Override
    public boolean isPlacementPolicySatisfied() {
        return this.parentBlockPlacementStatus.isPlacementPolicySatisfied() && this.isNodeGroupPolicySatisfied();
    }

    private boolean isNodeGroupPolicySatisfied() {
        return this.requiredNodeGroups <= this.currentNodeGroups.size();
    }

    @Override
    public String getErrorDescription() {
        if (this.isPlacementPolicySatisfied()) {
            return null;
        }
        StringBuilder errorDescription = new StringBuilder();
        if (!this.parentBlockPlacementStatus.isPlacementPolicySatisfied()) {
            errorDescription.append(this.parentBlockPlacementStatus.getErrorDescription());
        }
        if (!this.isNodeGroupPolicySatisfied()) {
            if (errorDescription.length() != 0) {
                errorDescription.append(" ");
            }
            errorDescription.append("The block has " + this.requiredNodeGroups + " replicas. But it only has " + this.currentNodeGroups.size() + " node groups " + this.currentNodeGroups + ".");
        }
        return errorDescription.toString();
    }
}

