/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.GSet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity;
    private GSet<Block, BlockInfo> blocks;

    BlocksMap(int capacity) {
        this.capacity = capacity;
        this.blocks = new LightWeightGSet<Block, BlockInfo>(capacity){

            @Override
            public Iterator<BlockInfo> iterator() {
                LightWeightGSet.SetIterator iterator = new LightWeightGSet.SetIterator();
                iterator.setTrackModification(false);
                return iterator;
            }
        };
    }

    void close() {
        this.clear();
        this.blocks = null;
    }

    void clear() {
        if (this.blocks != null) {
            this.blocks.clear();
        }
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) {
        BlockInfo info = this.blocks.get(b);
        if (info != b) {
            info = b;
            this.blocks.put(info);
        }
        info.setBlockCollectionId(bc.getId());
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = this.blocks.remove(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setBlockCollectionId(-1L);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            if (dn == null) continue;
            BlocksMap.removeBlock(dn, blockInfo);
        }
    }

    BlockInfo getStoredBlock(Block b) {
        return this.blocks.get(b);
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b) {
        return this.getStorages(this.blocks.get(b));
    }

    Iterable<DatanodeStorageInfo> getStorages(final BlockInfo storedBlock) {
        return new Iterable<DatanodeStorageInfo>(){

            @Override
            public Iterator<DatanodeStorageInfo> iterator() {
                return new StorageIterator(storedBlock);
            }
        };
    }

    int numNodes(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.blocks.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = BlocksMap.removeBlock(node, info);
        if (info.getDatanode(0) == null && info.isDeleted()) {
            this.blocks.remove(b);
        }
        return removed;
    }

    static boolean removeBlock(DatanodeDescriptor dn, BlockInfo b) {
        DatanodeStorageInfo s = b.findStorageInfo(dn);
        return s != null && s.removeBlock(b);
    }

    int size() {
        if (this.blocks != null) {
            return this.blocks.size();
        }
        return 0;
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    private static class StorageIterator
    implements Iterator<DatanodeStorageInfo> {
        private final BlockInfo blockInfo;
        private int nextIdx = 0;

        StorageIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeStorageInfo next() {
            return this.blockInfo.getStorageInfo(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

