/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web.SimpleHttpProxyHandler;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;

class URLDispatcher
extends SimpleChannelInboundHandler<HttpRequest> {
    private final InetSocketAddress proxyHost;
    private final Configuration conf;
    private final Configuration confForCreate;

    URLDispatcher(InetSocketAddress proxyHost, Configuration conf, Configuration confForCreate) {
        this.proxyHost = proxyHost;
        this.conf = conf;
        this.confForCreate = confForCreate;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        String uri = req.getUri();
        ChannelPipeline p = ctx.pipeline();
        if (uri.startsWith("/webhdfs/v1")) {
            WebHdfsHandler h = new WebHdfsHandler(this.conf, this.confForCreate);
            p.replace((ChannelHandler)this, WebHdfsHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        } else {
            SimpleHttpProxyHandler h = new SimpleHttpProxyHandler(this.proxyHost);
            p.replace((ChannelHandler)this, SimpleHttpProxyHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        }
    }
}

