/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.Storage;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class FSImageStorageInspector {
    FSImageStorageInspector() {
    }

    abstract void inspectDirectory(Storage.StorageDirectory var1) throws IOException;

    abstract boolean isUpgradeFinalized();

    abstract List<FSImageFile> getLatestImages() throws IOException;

    abstract long getMaxSeenTxId();

    abstract boolean needToSave();

    static class FSImageFile {
        final Storage.StorageDirectory sd;
        final long txId;
        private final File file;

        FSImageFile(Storage.StorageDirectory sd, File file, long txId) {
            assert (txId >= 0L || txId == -12345L) : "Invalid txid on " + file + ": " + txId;
            this.sd = sd;
            this.txId = txId;
            this.file = file;
        }

        File getFile() {
            return this.file;
        }

        public long getCheckpointTxId() {
            return this.txId;
        }

        public String toString() {
            return String.format("FSImageFile(file=%s, cpktTxId=%019d)", this.file.toString(), this.txId);
        }
    }
}

