/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.cli.Options;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.cli.PosixParser;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    private static final String HELP_OPT = "-h";
    private static final String HELP_LONGOPT = "--help";
    public static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * ReverseXML: This processor takes an XML file and creates a\n    binary fsimage containing the same elements.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage or XML file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n                       If the input file was an XML file, we\n                       will also create an <outputFile>.md5 file.\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|\n                       ReverseXML|Web|Delimited)\n                       The default is Web.\n-delimiter <arg>       Delimiting string to use with Delimited processor.  \n-t,--temp <arg>        Use temporary dir to cache intermediate result to generate\n                       Delimited outputs. If not set, Delimited processor constructs\n                       the namespace in memory before outputting text.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("inputFile");
        options.addOption(OptionBuilder.create("i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        System.exit(status);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int run(String[] args) throws Exception {
        options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        if (args.length == 1 && OfflineImageViewerPB.isHelpOption(args[0])) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        inputFile = cmd.getOptionValue("i");
        processor = cmd.getOptionValue("p", "Web");
        outputFile = cmd.getOptionValue("o", "-");
        delimiter = cmd.getOptionValue("delimiter", "\t");
        tempPath = cmd.getOptionValue("t", "");
        conf = new Configuration();
        try {
            out = outputFile.equals("-") != false ? System.out : new PrintStream(outputFile, "UTF-8");
            var11_14 = null;
            try {
                var12_15 = processor;
                var13_18 = -1;
                switch (var12_15.hashCode()) {
                    case -1749581248: {
                        if (!var12_15.equals("FileDistribution")) break;
                        var13_18 = 0;
                        break;
                    }
                    case 87031: {
                        if (!var12_15.equals("XML")) break;
                        var13_18 = 1;
                        break;
                    }
                    case 1211259381: {
                        if (!var12_15.equals("ReverseXML")) break;
                        var13_18 = 2;
                        break;
                    }
                    case 86836: {
                        if (!var12_15.equals("Web")) break;
                        var13_18 = 3;
                        break;
                    }
                    case 1753449945: {
                        if (!var12_15.equals("Delimited")) break;
                        var13_18 = 4;
                        break;
                    }
                }
                switch (var13_18) {
                    case 0: {
                        maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                        step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                        new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
                        break;
                    }
                    case 1: {
                        new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
                        break;
                    }
                    case 2: {
                        try {
                            OfflineImageReconstructor.run(inputFile, outputFile);
                        }
                        catch (Exception e) {
                            System.err.println("OfflineImageReconstructor failed: " + e.getMessage());
                            e.printStackTrace(System.err);
                            System.exit(1);
                        }
                        break;
                    }
                    case 3: {
                        addr = cmd.getOptionValue("addr", "localhost:5978");
                        viewer = new WebImageViewer(NetUtils.createSocketAddr(addr));
                        var19_27 = null;
                        try {
                            viewer.start(inputFile);
                            if (viewer == null) break;
                            if (var19_27 != null) {
                            }
                            ** GOTO lbl101
                        }
                        catch (Throwable var20_31) {
                            try {
                                var19_27 = var20_31;
                                throw var20_31;
                            }
                            catch (Throwable var21_34) {
                                if (viewer == null) throw var21_34;
                                if (var19_27 == null) {
                                    viewer.close();
                                    throw var21_34;
                                }
                                try {
                                    viewer.close();
                                    throw var21_34;
                                }
                                catch (Throwable var22_35) {
                                    var19_27.addSuppressed(var22_35);
                                    throw var21_34;
                                }
                            }
                        }
                        try {
                            viewer.close();
                        }
                        catch (Throwable var20_30) {
                            var19_27.addSuppressed(var20_30);
                        }
                        break;
lbl101:
                        // 1 sources

                        viewer.close();
                        break;
                    }
                    case 4: {
                        writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath);
                        var19_28 = null;
                        try {
                            writer.visit(new RandomAccessFile(inputFile, "r"));
                            if (writer == null) break;
                            if (var19_28 != null) {
                            }
                            ** GOTO lbl133
                        }
                        catch (Throwable var20_33) {
                            try {
                                var19_28 = var20_33;
                                throw var20_33;
                            }
                            catch (Throwable var23_36) {
                                if (writer == null) throw var23_36;
                                if (var19_28 == null) {
                                    writer.close();
                                    throw var23_36;
                                }
                                try {
                                    writer.close();
                                    throw var23_36;
                                }
                                catch (Throwable var24_37) {
                                    var19_28.addSuppressed(var24_37);
                                    throw var23_36;
                                }
                            }
                        }
                        try {
                            writer.close();
                        }
                        catch (Throwable var20_32) {
                            var19_28.addSuppressed(var20_32);
                        }
                        break;
lbl133:
                        // 1 sources

                        writer.close();
                        break;
                    }
                    default: {
                        System.err.println("Invalid processor specified : " + processor);
                        OfflineImageViewerPB.printUsage();
                        var18_26 = -1;
                        return var18_26;
                    }
                }
                var12_16 = 0;
                return var12_16;
            }
            catch (Throwable var12_17) {
                var11_14 = var12_17;
                throw var12_17;
            }
            finally {
                if (out != null) {
                    if (var11_14 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable var19_29) {
                            var11_14.addSuppressed(var19_29);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
            return -1;
        }
        catch (IOException e) {
            System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }

    private static boolean isHelpOption(String arg) {
        return arg.equalsIgnoreCase(HELP_OPT) || arg.equalsIgnoreCase(HELP_LONGOPT);
    }
}

