/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.serializer.Deserializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.serializer.Serialization;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.serializer.Serializer;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class JavaSerialization
implements Serialization<Serializable> {
    @Override
    @InterfaceAudience.Private
    public boolean accept(Class<?> c) {
        return Serializable.class.isAssignableFrom(c);
    }

    @Override
    @InterfaceAudience.Private
    public Deserializer<Serializable> getDeserializer(Class<Serializable> c) {
        return new JavaSerializationDeserializer<Serializable>();
    }

    @Override
    @InterfaceAudience.Private
    public Serializer<Serializable> getSerializer(Class<Serializable> c) {
        return new JavaSerializationSerializer();
    }

    static class JavaSerializationSerializer
    implements Serializer<Serializable> {
        private ObjectOutputStream oos;

        JavaSerializationSerializer() {
        }

        @Override
        public void open(OutputStream out) throws IOException {
            this.oos = new ObjectOutputStream(out){

                @Override
                protected void writeStreamHeader() {
                }
            };
        }

        @Override
        public void serialize(Serializable object) throws IOException {
            this.oos.reset();
            this.oos.writeObject(object);
        }

        @Override
        public void close() throws IOException {
            this.oos.close();
        }
    }

    static class JavaSerializationDeserializer<T extends Serializable>
    implements Deserializer<T> {
        private ObjectInputStream ois;

        JavaSerializationDeserializer() {
        }

        @Override
        public void open(InputStream in) throws IOException {
            this.ois = new ObjectInputStream(in){

                @Override
                protected void readStreamHeader() {
                }
            };
        }

        @Override
        public T deserialize(T object) throws IOException {
            try {
                return (T)((Serializable)this.ois.readObject());
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public void close() throws IOException {
            this.ois.close();
        }
    }
}

