/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String includesFile;
    private String excludesFile;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.writeLock = rwLock.writeLock();
        this.readLock = rwLock.readLock();
        this.refresh();
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        this.includesFile = includesFile;
        this.excludesFile = excludesFile;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.writeLock = rwLock.writeLock();
        this.readLock = rwLock.readLock();
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            block3: while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = nodes[i].trim();
                    if (nodes[i].startsWith("#")) continue block3;
                    if (nodes[i].isEmpty()) continue;
                    LOG.info("Adding a node \"" + nodes[i] + "\" to the list of " + type + " hosts from " + filename);
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public void refresh() throws IOException {
        this.writeLock.lock();
        try {
            this.refresh(this.includesFile, this.excludesFile);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String includeFiles, String excludeFiles) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        this.writeLock.lock();
        try {
            this.updateFileNames(includeFiles, excludeFiles);
            HashSet<String> newIncludes = new HashSet<String>();
            HashSet<String> newExcludes = new HashSet<String>();
            boolean switchIncludes = false;
            boolean switchExcludes = false;
            if (includeFiles != null && !includeFiles.isEmpty()) {
                HostsFileReader.readFileToSet("included", includeFiles, newIncludes);
                switchIncludes = true;
            }
            if (excludeFiles != null && !excludeFiles.isEmpty()) {
                HostsFileReader.readFileToSet("excluded", excludeFiles, newExcludes);
                switchExcludes = true;
            }
            if (switchIncludes) {
                this.includes = newIncludes;
            }
            if (switchExcludes) {
                this.excludes = newExcludes;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        this.writeLock.lock();
        try {
            HashSet<String> newIncludes = new HashSet<String>();
            HashSet<String> newExcludes = new HashSet<String>();
            boolean switchIncludes = false;
            boolean switchExcludes = false;
            if (inFileInputStream != null) {
                HostsFileReader.readFileToSetWithFileInputStream("included", this.includesFile, inFileInputStream, newIncludes);
                switchIncludes = true;
            }
            if (exFileInputStream != null) {
                HostsFileReader.readFileToSetWithFileInputStream("excluded", this.excludesFile, exFileInputStream, newExcludes);
                switchExcludes = true;
            }
            if (switchIncludes) {
                this.includes = newIncludes;
            }
            if (switchExcludes) {
                this.excludes = newExcludes;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getHosts() {
        this.readLock.lock();
        try {
            Set<String> set = this.includes;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getExcludedHosts() {
        this.readLock.lock();
        try {
            Set<String> set = this.excludes;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getHostDetails(Set<String> includes, Set<String> excludes) {
        this.readLock.lock();
        try {
            includes.addAll(this.includes);
            excludes.addAll(this.excludes);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setIncludesFile(String includesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        this.includesFile = includesFile;
    }

    public void setExcludesFile(String excludesFile) {
        LOG.info("Setting the excludes file to " + excludesFile);
        this.excludesFile = excludesFile;
    }

    public void updateFileNames(String includeFiles, String excludeFiles) {
        this.writeLock.lock();
        try {
            this.setIncludesFile(includeFiles);
            this.setExcludesFile(excludeFiles);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

