/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.core.Tracer;

public class TraceExecutorService
implements ExecutorService {
    private final Tracer tracer;
    private final String scopeName;
    private final ExecutorService impl;

    TraceExecutorService(Tracer tracer, String scopeName, ExecutorService impl) {
        this.tracer = tracer;
        this.scopeName = scopeName;
        this.impl = impl;
    }

    @Override
    public void execute(Runnable command) {
        this.impl.execute(this.tracer.wrap(command, this.scopeName));
    }

    @Override
    public void shutdown() {
        this.impl.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.impl.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.impl.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.impl.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.impl.submit(this.tracer.wrap(task, this.scopeName));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.impl.submit(this.tracer.wrap(task, this.scopeName), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.impl.submit(this.tracer.wrap(task, this.scopeName));
    }

    private <T> Collection<? extends Callable<T>> wrapCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> result = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            result.add(this.tracer.wrap(task, this.scopeName));
        }
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.impl.invokeAny(this.wrapCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.impl.invokeAny(this.wrapCollection(tasks), timeout, unit);
    }
}

