/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String fullString, String segment, JsonPointer next) {
        this._asString = fullString;
        this._nextSegment = next;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = JsonPointer._parseIndex(segment);
    }

    public static JsonPointer compile(String input) throws IllegalArgumentException {
        if (input == null || input.length() == 0) {
            return EMPTY;
        }
        if (input.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + input + "\"");
        }
        return JsonPointer._parseTail(input);
    }

    public static JsonPointer valueOf(String input) {
        return JsonPointer.compile(input);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer matchProperty(String name) {
        if (this._nextSegment == null || !this._matchingPropertyName.equals(name)) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer matchElement(int index) {
        if (index != this._matchingElementIndex || index < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)o)._asString);
    }

    private static final int _parseIndex(String str) {
        long l;
        int len = str.length();
        if (len == 0 || len > 10) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            char c;
            if ((c = str.charAt(i++)) <= '9' && c >= '0') continue;
            return -1;
        }
        if (len == 10 && (l = NumberInput.parseLong(str)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(str);
    }

    protected static JsonPointer _parseTail(String input) {
        int end = input.length();
        int i = 1;
        while (i < end) {
            char c = input.charAt(i);
            if (c == '/') {
                return new JsonPointer(input, input.substring(1, i), JsonPointer._parseTail(input.substring(i)));
            }
            if (c != '~' || ++i >= end) continue;
            return JsonPointer._parseQuotedTail(input, i);
        }
        return new JsonPointer(input, input.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String input, int i) {
        int end = input.length();
        StringBuilder sb = new StringBuilder(Math.max(16, end));
        if (i > 2) {
            sb.append(input, 1, i - 1);
        }
        JsonPointer._appendEscape(sb, input.charAt(i++));
        while (i < end) {
            char c = input.charAt(i);
            if (c == '/') {
                return new JsonPointer(input, sb.toString(), JsonPointer._parseTail(input.substring(i)));
            }
            if (c == '~' && ++i < end) {
                JsonPointer._appendEscape(sb, input.charAt(i++));
                continue;
            }
            sb.append(c);
        }
        return new JsonPointer(input, sb.toString(), EMPTY);
    }

    private static void _appendEscape(StringBuilder sb, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            sb.append('~');
        }
        sb.append(c);
    }
}

