/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

