/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.JsonToken;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.util.JsonParserSequence;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.util.TokenBuffer;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 5345570420394408290L;

    public AsArrayTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public AsArrayTypeDeserializer(AsArrayTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsArrayTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    private final Object _deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (jp.canReadTypeId() && (typeId = jp.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jp, ctxt, typeId);
        }
        boolean hadStartArray = jp.isExpectedStartArrayToken();
        String typeId2 = this._locateTypeId(jp, ctxt);
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId2);
        if (this._typeIdVisible && jp.getCurrentToken() == JsonToken.START_OBJECT) {
            TokenBuffer tb = new TokenBuffer(null, false);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString(typeId2);
            jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
            jp.nextToken();
        }
        Object value = deser.deserialize(jp, ctxt);
        if (hadStartArray && jp.nextToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value");
        }
        return value;
    }

    protected final String _locateTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!jp.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                return this._idResolver.idFromBaseType();
            }
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "need JSON Array to contain As.WRAPPER_ARRAY type information for class " + this.baseTypeName());
        }
        JsonToken t = jp.nextToken();
        if (t == JsonToken.VALUE_STRING) {
            String result = jp.getText();
            jp.nextToken();
            return result;
        }
        if (this._defaultImpl != null) {
            return this._idResolver.idFromBaseType();
        }
        throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
    }
}

