/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.utils.TypeConversions;

public final class FunctionLookupMock
implements FunctionLookup {
    private final Map<FunctionIdentifier, FunctionDefinition> functions;

    public FunctionLookupMock(Map<FunctionIdentifier, FunctionDefinition> functions) {
        this.functions = functions;
    }

    public Optional<ContextResolvedFunction> lookupFunction(String stringIdentifier) {
        return this.lookupFunction(UnresolvedIdentifier.of((String[])stringIdentifier.split("\\.")));
    }

    public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
        FunctionIdentifier functionIdentifier = identifier.getCatalogName().isPresent() && identifier.getDatabaseName().isPresent() ? FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)((String)identifier.getCatalogName().get()), (String)((String)identifier.getDatabaseName().get()), (String)identifier.getObjectName())) : FunctionIdentifier.of((String)identifier.getObjectName());
        return Optional.ofNullable(this.functions.get(functionIdentifier)).map(func -> ContextResolvedFunction.permanent((FunctionIdentifier)functionIdentifier, (FunctionDefinition)func));
    }

    public ContextResolvedFunction lookupBuiltInFunction(BuiltInFunctionDefinition definition) {
        return ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((String)definition.getName()), (FunctionDefinition)definition);
    }

    public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil() {
        return (unresolvedCall, resolvedArgs) -> {
            FunctionDefinition functionDefinition = unresolvedCall.getFunctionDefinition();
            List argumentTypes = resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
            if (functionDefinition.equals(BuiltInFunctionDefinitions.EQUALS)) {
                return new TypeInferenceUtil.Result(argumentTypes, null, DataTypes.BOOLEAN());
            }
            if (functionDefinition.equals(BuiltInFunctionDefinitions.IS_NULL)) {
                return new TypeInferenceUtil.Result(argumentTypes, null, DataTypes.BOOLEAN());
            }
            if (functionDefinition instanceof ScalarFunctionDefinition) {
                return new TypeInferenceUtil.Result(argumentTypes, null, TypeConversions.fromLegacyInfoToDataType((TypeInformation)((ScalarFunctionDefinition)functionDefinition).getScalarFunction().getResultType(null)));
            }
            throw new IllegalArgumentException("Unsupported builtin function in the test: " + unresolvedCall);
        };
    }
}

