/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QueryOperationTest {
    QueryOperationTest() {
    }

    @Test
    void testSummaryString() {
        ResolvedSchema schema = ResolvedSchema.physical(Collections.singletonList("a"), Collections.singletonList(DataTypes.INT()));
        ProjectQueryOperation tableOperation = new ProjectQueryOperation(Collections.singletonList(new FieldReferenceExpression("a", DataTypes.INT(), 0, 0)), (QueryOperation)new SourceQueryOperation(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tab1"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().build(), null, Collections.emptyList(), Collections.emptyMap()), schema))), schema);
        SetQueryOperation unionQueryOperation = new SetQueryOperation((QueryOperation)tableOperation, (QueryOperation)tableOperation, SetQueryOperation.SetQueryOperationType.UNION, true, schema);
        Assertions.assertThat((String)unionQueryOperation.asSummaryString()).isEqualTo("Union: (all: [true])\n    Project: (projections: [a])\n        CatalogTable: (identifier: [cat1.db1.tab1], fields: [a])\n    Project: (projections: [a])\n        CatalogTable: (identifier: [cat1.db1.tab1], fields: [a])");
    }

    @Test
    void testWindowAggregationSummaryString() {
        ResolvedSchema schema = ResolvedSchema.physical(Collections.singletonList("a"), Collections.singletonList(DataTypes.INT()));
        FieldReferenceExpression field = new FieldReferenceExpression("a", DataTypes.INT(), 0, 0);
        WindowAggregateQueryOperation tableOperation = new WindowAggregateQueryOperation(Collections.singletonList(field), Collections.singletonList(CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.SUM, Collections.singletonList(field), (DataType)DataTypes.INT())), Collections.emptyList(), WindowAggregateQueryOperation.ResolvedGroupWindow.sessionWindow((String)"w", (FieldReferenceExpression)field, (ValueLiteralExpression)ApiExpressionUtils.intervalOfMillis((long)10L)), (QueryOperation)new SourceQueryOperation(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tab1"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().build(), null, Collections.emptyList(), Collections.emptyMap()), schema))), schema);
        DistinctQueryOperation distinctQueryOperation = new DistinctQueryOperation((QueryOperation)tableOperation);
        Assertions.assertThat((String)distinctQueryOperation.asSummaryString()).isEqualTo("Distinct:\n    WindowAggregate: (group: [a], agg: [sum(a)], windowProperties: [], window: [SessionWindow(field: [a], gap: [10])])\n        CatalogTable: (identifier: [cat1.db1.tab1], fields: [a])");
    }

    @Test
    void testIndentation() {
        String input = "firstLevel\n    secondLevel0\n        thirdLevel0\n    secondLevel1\n        thirdLevel1";
        String indentedInput = OperationUtils.indent((String)input);
        Assertions.assertThat((String)indentedInput).isEqualTo("\n    firstLevel\n        secondLevel0\n            thirdLevel0\n        secondLevel1\n            thirdLevel1");
    }
}

