/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.utils.ExpressionResolverMocks;

public final class CatalogManagerMocks {
    public static final String DEFAULT_CATALOG = (String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue();
    public static final String DEFAULT_DATABASE = (String)TableConfigOptions.TABLE_DATABASE_NAME.defaultValue();

    public static CatalogManager createEmptyCatalogManager() {
        return CatalogManagerMocks.createCatalogManager(null);
    }

    public static CatalogManager createCatalogManager(@Nullable Catalog catalog) {
        CatalogManager.Builder builder = CatalogManagerMocks.preparedCatalogManager();
        if (catalog != null) {
            builder.defaultCatalog(DEFAULT_CATALOG, catalog);
        }
        CatalogManager catalogManager = builder.build();
        catalogManager.initSchemaResolver(true, ExpressionResolverMocks.dummyResolver());
        return catalogManager;
    }

    public static CatalogManager.Builder preparedCatalogManager() {
        return CatalogManager.newBuilder().classLoader(CatalogManagerMocks.class.getClassLoader()).config((ReadableConfig)new Configuration()).defaultCatalog(DEFAULT_CATALOG, CatalogManagerMocks.createEmptyCatalog()).executionConfig(new ExecutionConfig());
    }

    public static Catalog createEmptyCatalog() {
        return new GenericInMemoryCatalog(DEFAULT_CATALOG, DEFAULT_DATABASE);
    }

    private CatalogManagerMocks() {
    }
}

