/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTestUtil;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.types.DataType;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class CatalogTest {
    protected static final String IS_STREAMING = "is_streaming";
    protected final String db1 = "db1";
    protected final String db2 = "db2";
    protected final String t1 = "t1";
    protected final String t2 = "t2";
    protected final String t3 = "t3";
    protected final ObjectPath path1 = new ObjectPath("db1", "t1");
    protected final ObjectPath path2 = new ObjectPath("db2", "t2");
    protected final ObjectPath path3 = new ObjectPath("db1", "t2");
    protected final ObjectPath path4 = new ObjectPath("db1", "t3");
    protected final ObjectPath nonExistDbPath = ObjectPath.fromString((String)"non.exist");
    protected final ObjectPath nonExistObjectPath = ObjectPath.fromString((String)"db1.nonexist");
    public static final String TEST_CATALOG_NAME = "test-catalog";
    protected static final String TEST_COMMENT = "test comment";
    protected static Catalog catalog;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @After
    public void cleanup() throws Exception {
        if (catalog.tableExists(this.path1)) {
            catalog.dropTable(this.path1, true);
        }
        if (catalog.tableExists(this.path2)) {
            catalog.dropTable(this.path2, true);
        }
        if (catalog.tableExists(this.path3)) {
            catalog.dropTable(this.path3, true);
        }
        if (catalog.tableExists(this.path4)) {
            catalog.dropTable(this.path4, true);
        }
        if (catalog.functionExists(this.path1)) {
            catalog.dropFunction(this.path1, true);
        }
        if (catalog.databaseExists("db1")) {
            catalog.dropDatabase("db1", true, false);
        }
        if (catalog.databaseExists("db2")) {
            catalog.dropDatabase("db2", true, false);
        }
    }

    @AfterClass
    public static void closeup() {
        if (catalog != null) {
            catalog.close();
        }
    }

    @Test
    public void testCreateDb() throws Exception {
        Assert.assertFalse((boolean)catalog.databaseExists("db1"));
        CatalogDatabase cd = this.createDb();
        catalog.createDatabase("db1", cd, false);
        Assert.assertTrue((boolean)catalog.databaseExists("db1"));
        CatalogTestUtil.checkEquals(cd, catalog.getDatabase("db1"));
    }

    @Test
    public void testCreateDb_DatabaseAlreadyExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(DatabaseAlreadyExistException.class);
        this.exception.expectMessage("Database db1 already exists in Catalog");
        catalog.createDatabase("db1", this.createDb(), false);
    }

    @Test
    public void testCreateDb_DatabaseAlreadyExist_ignored() throws Exception {
        CatalogDatabase cd1 = this.createDb();
        catalog.createDatabase("db1", cd1, false);
        List dbs = catalog.listDatabases();
        CatalogTestUtil.checkEquals(cd1, catalog.getDatabase("db1"));
        Assert.assertEquals((long)2L, (long)dbs.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("db1", catalog.getDefaultDatabase())), new HashSet(dbs));
        catalog.createDatabase("db1", this.createAnotherDb(), true);
        CatalogTestUtil.checkEquals(cd1, catalog.getDatabase("db1"));
        Assert.assertEquals((long)2L, (long)dbs.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("db1", catalog.getDefaultDatabase())), new HashSet(dbs));
    }

    @Test
    public void testGetDb_DatabaseNotExistException() throws Exception {
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database nonexistent does not exist in Catalog");
        catalog.getDatabase("nonexistent");
    }

    @Test
    public void testDropDb() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertTrue((boolean)catalog.databaseExists("db1"));
        catalog.dropDatabase("db1", false, true);
        Assert.assertFalse((boolean)catalog.databaseExists("db1"));
    }

    @Test
    public void testDropDb_DatabaseNotExistException() throws Exception {
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database db1 does not exist in Catalog");
        catalog.dropDatabase("db1", false, false);
    }

    @Test
    public void testDropDb_DatabaseNotExist_Ignore() throws Exception {
        catalog.dropDatabase("db1", true, false);
    }

    @Test
    public void testDropDb_DatabaseNotEmptyException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        this.exception.expect(DatabaseNotEmptyException.class);
        this.exception.expectMessage("Database db1 in catalog test-catalog is not empty");
        catalog.dropDatabase("db1", true, false);
    }

    @Test
    public void testAlterDb() throws Exception {
        CatalogDatabase db = this.createDb();
        catalog.createDatabase("db1", db, false);
        CatalogDatabase newDb = this.createAnotherDb();
        catalog.alterDatabase("db1", newDb, false);
        Assert.assertFalse((boolean)catalog.getDatabase("db1").getProperties().entrySet().containsAll(db.getProperties().entrySet()));
        CatalogTestUtil.checkEquals(newDb, catalog.getDatabase("db1"));
    }

    @Test
    public void testAlterDb_DatabaseNotExistException() throws Exception {
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database nonexistent does not exist in Catalog");
        catalog.alterDatabase("nonexistent", this.createDb(), false);
    }

    @Test
    public void testAlterDb_DatabaseNotExist_ignored() throws Exception {
        catalog.alterDatabase("nonexistent", this.createDb(), true);
        Assert.assertFalse((boolean)catalog.databaseExists("nonexistent"));
    }

    @Test
    public void testDbExists() throws Exception {
        Assert.assertFalse((boolean)catalog.databaseExists("nonexistent"));
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertTrue((boolean)catalog.databaseExists("db1"));
    }

    @Test
    public void testCreateTable_Streaming() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createStreamingTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
    }

    @Test
    public void testCreateTable_Batch() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogBaseTable tableCreated = catalog.getTable(this.path1);
        CatalogTestUtil.checkEquals(table, (CatalogTable)tableCreated);
        Assert.assertEquals((Object)TEST_COMMENT, tableCreated.getDescription().get());
        List tables = catalog.listTables("db1");
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)this.path1.getObjectName(), tables.get(0));
        catalog.dropTable(this.path1, false);
    }

    @Test
    public void testCreatePartitionedTable_Batch() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
        List tables = catalog.listTables("db1");
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)this.path1.getObjectName(), tables.get(0));
    }

    @Test
    public void testCreateTable_DatabaseNotExistException() throws Exception {
        Assert.assertFalse((boolean)catalog.databaseExists("db1"));
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database db1 does not exist in Catalog");
        catalog.createTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(), false);
    }

    @Test
    public void testCreateTable_TableAlreadyExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        this.exception.expect(TableAlreadyExistException.class);
        this.exception.expectMessage("Table (or view) db1.t1 already exists in Catalog");
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
    }

    @Test
    public void testCreateTable_TableAlreadyExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
        catalog.createTable(this.path1, (CatalogBaseTable)this.createAnotherTable(), true);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
    }

    @Test
    public void testGetTable_TableNotExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) db1.nonexist does not exist in Catalog");
        catalog.getTable(this.nonExistObjectPath);
    }

    @Test
    public void testGetTable_TableNotExistException_NoDb() throws Exception {
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) db1.nonexist does not exist in Catalog");
        catalog.getTable(this.nonExistObjectPath);
    }

    @Test
    public void testDropTable_nonPartitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        Assert.assertTrue((boolean)catalog.tableExists(this.path1));
        catalog.dropTable(this.path1, false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
    }

    @Test
    public void testDropTable_TableNotExistException() throws Exception {
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) non.exist does not exist in Catalog");
        catalog.dropTable(this.nonExistDbPath, false);
    }

    @Test
    public void testDropTable_TableNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.dropTable(this.nonExistObjectPath, true);
    }

    @Test
    public void testAlterTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
        CatalogTable newTable = this.createAnotherTable();
        catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        Assert.assertNotEquals((Object)table, (Object)catalog.getTable(this.path1));
        CatalogTestUtil.checkEquals(newTable, (CatalogTable)catalog.getTable(this.path1));
        catalog.dropTable(this.path1, false);
        CatalogView view = this.createView();
        catalog.createTable(this.path3, (CatalogBaseTable)view, false);
        CatalogTestUtil.checkEquals(view, (CatalogView)catalog.getTable(this.path3));
        CatalogView newView = this.createAnotherView();
        catalog.alterTable(this.path3, (CatalogBaseTable)newView, false);
        Assert.assertNotEquals((Object)view, (Object)catalog.getTable(this.path3));
        CatalogTestUtil.checkEquals(newView, (CatalogView)catalog.getTable(this.path3));
    }

    @Test
    public void testAlterPartitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
        CatalogTable newTable = this.createAnotherPartitionedTable();
        catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        CatalogTestUtil.checkEquals(newTable, (CatalogTable)catalog.getTable(this.path1));
    }

    @Test
    public void testAlterTable_differentTypedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.exception.expect(CatalogException.class);
        this.exception.expectMessage("Table types don't match. Existing table is 'TABLE' and new table is 'VIEW'.");
        catalog.alterTable(this.path1, (CatalogBaseTable)new TestTable(), false);
    }

    @Test
    public void testAlterTable_TableNotExistException() throws Exception {
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) non.exist does not exist in Catalog");
        catalog.alterTable(this.nonExistDbPath, (CatalogBaseTable)this.createTable(), false);
    }

    @Test
    public void testAlterTable_TableNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.alterTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(), true);
        Assert.assertFalse((boolean)catalog.tableExists(this.nonExistObjectPath));
    }

    @Test
    public void testRenameTable_nonPartitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path1));
        catalog.renameTable(this.path1, "t2", false);
        CatalogTestUtil.checkEquals(table, (CatalogTable)catalog.getTable(this.path3));
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
    }

    @Test
    public void testRenameTable_TableNotExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) db1.t1 does not exist in Catalog");
        catalog.renameTable(this.path1, "t2", false);
    }

    @Test
    public void testRenameTable_TableNotExistException_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.renameTable(this.path1, "t2", true);
    }

    @Test
    public void testRenameTable_TableAlreadyExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        catalog.createTable(this.path3, (CatalogBaseTable)this.createAnotherTable(), false);
        this.exception.expect(TableAlreadyExistException.class);
        this.exception.expectMessage("Table (or view) db1.t2 already exists in Catalog");
        catalog.renameTable(this.path1, "t2", false);
    }

    @Test
    public void testListTables() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        catalog.createTable(this.path3, (CatalogBaseTable)this.createTable(), false);
        catalog.createTable(this.path4, (CatalogBaseTable)this.createView(), false);
        Assert.assertEquals((long)3L, (long)catalog.listTables("db1").size());
        Assert.assertEquals((long)1L, (long)catalog.listViews("db1").size());
    }

    @Test
    public void testTableExists() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        Assert.assertTrue((boolean)catalog.tableExists(this.path1));
    }

    @Test
    public void testCreateView() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
        CatalogView view = this.createView();
        catalog.createTable(this.path1, (CatalogBaseTable)view, false);
        Assert.assertTrue((boolean)(catalog.getTable(this.path1) instanceof CatalogView));
        CatalogTestUtil.checkEquals(view, (CatalogView)catalog.getTable(this.path1));
    }

    @Test
    public void testCreateView_DatabaseNotExistException() throws Exception {
        Assert.assertFalse((boolean)catalog.databaseExists("db1"));
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database db1 does not exist in Catalog");
        catalog.createTable(this.nonExistObjectPath, (CatalogBaseTable)this.createView(), false);
    }

    @Test
    public void testCreateView_TableAlreadyExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createView(), false);
        this.exception.expect(TableAlreadyExistException.class);
        this.exception.expectMessage("Table (or view) db1.t1 already exists in Catalog");
        catalog.createTable(this.path1, (CatalogBaseTable)this.createView(), false);
    }

    @Test
    public void testCreateView_TableAlreadyExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogView view = this.createView();
        catalog.createTable(this.path1, (CatalogBaseTable)view, false);
        Assert.assertTrue((boolean)(catalog.getTable(this.path1) instanceof CatalogView));
        CatalogTestUtil.checkEquals(view, (CatalogView)catalog.getTable(this.path1));
        catalog.createTable(this.path1, (CatalogBaseTable)this.createAnotherView(), true);
        Assert.assertTrue((boolean)(catalog.getTable(this.path1) instanceof CatalogView));
        CatalogTestUtil.checkEquals(view, (CatalogView)catalog.getTable(this.path1));
    }

    @Test
    public void testDropView() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createView(), false);
        Assert.assertTrue((boolean)catalog.tableExists(this.path1));
        catalog.dropTable(this.path1, false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
    }

    @Test
    public void testAlterView() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogView view = this.createView();
        catalog.createTable(this.path1, (CatalogBaseTable)view, false);
        CatalogTestUtil.checkEquals(view, (CatalogView)catalog.getTable(this.path1));
        CatalogView newView = this.createAnotherView();
        catalog.alterTable(this.path1, (CatalogBaseTable)newView, false);
        Assert.assertTrue((boolean)(catalog.getTable(this.path1) instanceof CatalogView));
        CatalogTestUtil.checkEquals(newView, (CatalogView)catalog.getTable(this.path1));
    }

    @Test
    public void testAlterView_TableNotExistException() throws Exception {
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage("Table (or view) non.exist does not exist in Catalog");
        catalog.alterTable(this.nonExistDbPath, (CatalogBaseTable)this.createTable(), false);
    }

    @Test
    public void testAlterView_TableNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.alterTable(this.nonExistObjectPath, (CatalogBaseTable)this.createView(), true);
        Assert.assertFalse((boolean)catalog.tableExists(this.nonExistObjectPath));
    }

    @Test
    public void testListView() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertTrue((boolean)catalog.listTables("db1").isEmpty());
        catalog.createTable(this.path1, (CatalogBaseTable)this.createView(), false);
        catalog.createTable(this.path3, (CatalogBaseTable)this.createTable(), false);
        Assert.assertEquals((long)2L, (long)catalog.listTables("db1").size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList(this.path1.getObjectName(), this.path3.getObjectName())), new HashSet(catalog.listTables("db1")));
        Assert.assertEquals(Arrays.asList(this.path1.getObjectName()), (Object)catalog.listViews("db1"));
    }

    @Test
    public void testRenameView() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createView(), false);
        Assert.assertTrue((boolean)catalog.tableExists(this.path1));
        catalog.renameTable(this.path1, "t2", false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
        Assert.assertTrue((boolean)catalog.tableExists(this.path3));
    }

    @Test
    public void testCreateFunction() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        Assert.assertFalse((boolean)catalog.functionExists(this.path1));
        catalog.createFunction(this.path1, this.createFunction(), false);
        Assert.assertTrue((boolean)catalog.functionExists(this.path1));
    }

    @Test
    public void testCreatePythonFunction() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogFunction pythonFunction = this.createPythonFunction();
        catalog.createFunction(this.path1, this.createPythonFunction(), false);
        CatalogFunction actual = catalog.getFunction(this.path1);
        this.checkEquals(pythonFunction, actual);
    }

    @Test
    public void testCreateFunction_DatabaseNotExistException() throws Exception {
        Assert.assertFalse((boolean)catalog.databaseExists("db1"));
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database db1 does not exist in Catalog");
        catalog.createFunction(this.path1, this.createFunction(), false);
    }

    @Test
    public void testCreateFunction_FunctionAlreadyExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createFunction(this.path1, this.createFunction(), false);
        Assert.assertTrue((boolean)catalog.functionExists(this.path1));
        catalog.createFunction(this.path1, this.createAnotherFunction(), true);
        this.exception.expect(FunctionAlreadyExistException.class);
        this.exception.expectMessage("Function db1.t1 already exists in Catalog");
        catalog.createFunction(this.path1, this.createFunction(), false);
    }

    @Test
    public void testAlterFunction() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogFunction func = this.createFunction();
        catalog.createFunction(this.path1, func, false);
        this.checkEquals(func, catalog.getFunction(this.path1));
        CatalogFunction newFunc = this.createAnotherFunction();
        catalog.alterFunction(this.path1, newFunc, false);
        CatalogFunction actual = catalog.getFunction(this.path1);
        Assert.assertFalse((boolean)func.getClassName().equals(actual.getClassName()));
        this.checkEquals(newFunc, actual);
    }

    @Test
    public void testAlterPythonFunction() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogFunction func = this.createFunction();
        catalog.createFunction(this.path1, func, false);
        this.checkEquals(func, catalog.getFunction(this.path1));
        CatalogFunction newFunc = this.createPythonFunction();
        catalog.alterFunction(this.path1, newFunc, false);
        CatalogFunction actual = catalog.getFunction(this.path1);
        Assert.assertFalse((boolean)func.getClassName().equals(actual.getClassName()));
        this.checkEquals(newFunc, actual);
    }

    @Test
    public void testAlterFunction_FunctionNotExistException() throws Exception {
        this.exception.expect(FunctionNotExistException.class);
        this.exception.expectMessage("Function db1.nonexist does not exist in Catalog");
        catalog.alterFunction(this.nonExistObjectPath, this.createFunction(), false);
    }

    @Test
    public void testAlterFunction_FunctionNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.alterFunction(this.nonExistObjectPath, this.createFunction(), true);
        Assert.assertFalse((boolean)catalog.functionExists(this.nonExistObjectPath));
    }

    @Test
    public void testListFunctions() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogFunction func = this.createFunction();
        catalog.createFunction(this.path1, func, false);
        Assert.assertEquals((Object)this.path1.getObjectName(), catalog.listFunctions("db1").get(0));
    }

    @Test
    public void testListFunctions_DatabaseNotExistException() throws Exception {
        this.exception.expect(DatabaseNotExistException.class);
        this.exception.expectMessage("Database db1 does not exist in Catalog");
        catalog.listFunctions("db1");
    }

    @Test
    public void testGetFunction_FunctionNotExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(FunctionNotExistException.class);
        this.exception.expectMessage("Function db1.nonexist does not exist in Catalog");
        catalog.getFunction(this.nonExistObjectPath);
    }

    @Test
    public void testGetFunction_FunctionNotExistException_NoDb() throws Exception {
        this.exception.expect(FunctionNotExistException.class);
        this.exception.expectMessage("Function db1.nonexist does not exist in Catalog");
        catalog.getFunction(this.nonExistObjectPath);
    }

    @Test
    public void testDropFunction() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createFunction(this.path1, this.createFunction(), false);
        Assert.assertTrue((boolean)catalog.functionExists(this.path1));
        catalog.dropFunction(this.path1, false);
        Assert.assertFalse((boolean)catalog.functionExists(this.path1));
    }

    @Test
    public void testDropFunction_FunctionNotExistException() throws Exception {
        this.exception.expect(FunctionNotExistException.class);
        this.exception.expectMessage("Function non.exist does not exist in Catalog");
        catalog.dropFunction(this.nonExistDbPath, false);
    }

    @Test
    public void testDropFunction_FunctionNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.dropFunction(this.nonExistObjectPath, true);
        catalog.dropDatabase("db1", false, false);
    }

    @Test
    public void testCreatePartition() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        Assert.assertTrue((boolean)catalog.listPartitions(this.path1).isEmpty());
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1, this.createPartitionSpecSubset()));
        CatalogTestUtil.checkEquals(this.createPartition(), catalog.getPartition(this.path1, this.createPartitionSpec()));
        catalog.createPartition(this.path1, this.createAnotherPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals(Arrays.asList(this.createPartitionSpec(), this.createAnotherPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        Assert.assertEquals(Arrays.asList(this.createPartitionSpec(), this.createAnotherPartitionSpec()), (Object)catalog.listPartitions(this.path1, this.createPartitionSpecSubset()));
        CatalogTestUtil.checkEquals(this.createPartition(), catalog.getPartition(this.path1, this.createAnotherPartitionSpec()));
    }

    @Test
    public void testCreatePartition_TableNotExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(TableNotExistException.class);
        this.exception.expectMessage(String.format("Table (or view) %s does not exist in Catalog %s.", this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
    }

    @Test
    public void testCreatePartition_TableNotPartitionedException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        this.exception.expect(TableNotPartitionedException.class);
        this.exception.expectMessage(String.format("Table %s in catalog %s is not partitioned.", this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
    }

    @Test
    public void testCreatePartition_PartitionSpecInvalidException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = this.createInvalidPartitionSpecSubset();
        this.exception.expect(PartitionSpecInvalidException.class);
        this.exception.expectMessage(String.format("PartitionSpec %s does not match partition keys %s of table %s in catalog %s.", partitionSpec, table.getPartitionKeys(), this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testCreatePartition_PartitionAlreadyExistsException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartition partition = this.createPartition();
        catalog.createPartition(this.path1, this.createPartitionSpec(), partition, false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionAlreadyExistsException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s already exists.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testCreatePartition_PartitionAlreadyExists_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), false);
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), true);
    }

    @Test
    public void testDropPartition() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        catalog.dropPartition(this.path1, this.createPartitionSpec(), false);
        Assert.assertEquals(Collections.emptyList(), (Object)catalog.listPartitions(this.path1));
    }

    @Test
    public void testDropPartition_TableNotExist() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.dropPartition(this.path1, partitionSpec, false);
    }

    @Test
    public void testDropPartition_TableNotPartitioned() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.dropPartition(this.path1, partitionSpec, false);
    }

    @Test
    public void testDropPartition_PartitionSpecInvalid() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = this.createInvalidPartitionSpecSubset();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.dropPartition(this.path1, partitionSpec, false);
    }

    @Test
    public void testDropPartition_PartitionNotExist() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.dropPartition(this.path1, partitionSpec, false);
    }

    @Test
    public void testDropPartition_PartitionNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.dropPartition(this.path1, this.createPartitionSpec(), true);
    }

    @Test
    public void testAlterPartition() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        CatalogPartition cp = catalog.getPartition(this.path1, this.createPartitionSpec());
        CatalogTestUtil.checkEquals(this.createPartition(), cp);
        Assert.assertNull(cp.getProperties().get("k"));
        CatalogPartition another = this.createPartition();
        another.getProperties().put("k", "v");
        catalog.alterPartition(this.path1, this.createPartitionSpec(), another, false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        cp = catalog.getPartition(this.path1, this.createPartitionSpec());
        CatalogTestUtil.checkEquals(another, cp);
        Assert.assertEquals((Object)"v", cp.getProperties().get("k"));
    }

    @Test
    public void testAlterPartition_TableNotExist() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.alterPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testAlterPartition_TableNotPartitioned() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.alterPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testAlterPartition_PartitionSpecInvalid() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = this.createInvalidPartitionSpecSubset();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.alterPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testAlterPartition_PartitionNotExist() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.alterPartition(this.path1, partitionSpec, this.createPartition(), false);
    }

    @Test
    public void testAlterPartition_PartitionNotExist_ignored() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.alterPartition(this.path1, this.createPartitionSpec(), this.createPartition(), true);
    }

    @Test
    public void testGetPartition_TableNotExist() throws Exception {
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.getPartition(this.path1, partitionSpec);
    }

    @Test
    public void testGetPartition_TableNotPartitioned() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.getPartition(this.path1, partitionSpec);
    }

    @Test
    public void testGetPartition_PartitionSpecInvalid_invalidPartitionSpec() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = this.createInvalidPartitionSpecSubset();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.getPartition(this.path1, partitionSpec);
    }

    @Test
    public void testGetPartition_PartitionSpecInvalid_sizeNotEqual() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("second", "bob");
            }
        });
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.getPartition(this.path1, partitionSpec);
    }

    @Test
    public void testGetPartition_PartitionNotExist() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        this.exception.expect(PartitionNotExistException.class);
        this.exception.expectMessage(String.format("Partition %s of table %s in catalog %s does not exist.", partitionSpec, this.path1.getFullName(), TEST_CATALOG_NAME));
        catalog.getPartition(this.path1, partitionSpec);
    }

    @Test
    public void testPartitionExists() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        Assert.assertTrue((boolean)catalog.partitionExists(this.path1, this.createPartitionSpec()));
        Assert.assertFalse((boolean)catalog.partitionExists(this.path2, this.createPartitionSpec()));
        Assert.assertFalse((boolean)catalog.partitionExists(ObjectPath.fromString((String)"non.exist"), this.createPartitionSpec()));
    }

    @Test
    public void testListPartitionPartialSpec() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        catalog.createPartition(this.path1, this.createAnotherPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals((long)2L, (long)catalog.listPartitions(this.path1, this.createPartitionSpecSubset()).size());
        Assert.assertEquals((long)1L, (long)catalog.listPartitions(this.path1, this.createAnotherPartitionSpecSubset()).size());
    }

    @Test
    public void testGetTableStats_TableNotExistException() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.exception.expect(TableNotExistException.class);
        catalog.getTableStatistics(this.path1);
    }

    @Test
    public void testGetPartitionStats() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        CatalogTableStatistics tableStatistics = catalog.getPartitionStatistics(this.path1, this.createPartitionSpec());
        Assert.assertEquals((long)-1L, (long)tableStatistics.getFileCount());
        Assert.assertEquals((long)-1L, (long)tableStatistics.getRawDataSize());
        Assert.assertEquals((long)-1L, (long)tableStatistics.getTotalSize());
        Assert.assertEquals((long)-1L, (long)tableStatistics.getRowCount());
    }

    @Test
    public void testAlterTableStats() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTableStatistics tableStats = new CatalogTableStatistics(100L, 10, 1000L, 10000L);
        catalog.alterTableStatistics(this.path1, tableStats, false);
        CatalogTableStatistics actual = catalog.getTableStatistics(this.path1);
        Assert.assertEquals((long)tableStats.getRowCount(), (long)actual.getRowCount());
        Assert.assertEquals((long)tableStats.getRawDataSize(), (long)actual.getRawDataSize());
    }

    @Test
    public void testAlterTableStats_partitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable catalogTable = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogTableStatistics stats = new CatalogTableStatistics(100L, 1, 1000L, 10000L);
        catalog.alterTableStatistics(this.path1, stats, false);
        Assert.assertEquals((Object)CatalogTableStatistics.UNKNOWN, (Object)catalog.getTableStatistics(this.path1));
    }

    @Test
    public void testAlterPartitionTableStats() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable catalogTable = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), true);
        CatalogTableStatistics stats = new CatalogTableStatistics(100L, 1, 1000L, 10000L);
        catalog.alterPartitionStatistics(this.path1, partitionSpec, stats, false);
        CatalogTableStatistics actual = catalog.getPartitionStatistics(this.path1, partitionSpec);
        Assert.assertEquals((long)stats.getRowCount(), (long)actual.getRowCount());
        Assert.assertEquals((long)stats.getRawDataSize(), (long)actual.getRawDataSize());
    }

    @Test
    public void testAlterTableStats_TableNotExistException() throws Exception {
        this.exception.expect(TableNotExistException.class);
        catalog.alterTableStatistics(new ObjectPath(catalog.getDefaultDatabase(), "nonexist"), CatalogTableStatistics.UNKNOWN, false);
    }

    @Test
    public void testAlterTableStats_TableNotExistException_ignore() throws Exception {
        catalog.alterTableStatistics(new ObjectPath("non", "exist"), CatalogTableStatistics.UNKNOWN, true);
    }

    public abstract CatalogDatabase createDb();

    public abstract CatalogDatabase createAnotherDb();

    public abstract CatalogTable createTable();

    public abstract CatalogTable createAnotherTable();

    public abstract CatalogTable createStreamingTable();

    public abstract CatalogTable createPartitionedTable();

    public abstract CatalogTable createAnotherPartitionedTable();

    public abstract CatalogView createView();

    public abstract CatalogView createAnotherView();

    protected abstract CatalogFunction createFunction();

    protected abstract CatalogFunction createPythonFunction();

    protected abstract CatalogFunction createAnotherFunction();

    public abstract CatalogPartition createPartition();

    protected ResolvedSchema createSchema() {
        return new ResolvedSchema(Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.INT()), Column.physical((String)"third", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
    }

    protected ResolvedSchema createAnotherSchema() {
        return new ResolvedSchema(Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.STRING()), Column.physical((String)"third", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
    }

    protected List<String> createPartitionKeys() {
        return Arrays.asList("second", "third");
    }

    protected CatalogPartitionSpec createPartitionSpec() {
        return new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("third", "2000");
                this.put("second", "bob");
            }
        });
    }

    protected CatalogPartitionSpec createAnotherPartitionSpec() {
        return new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("third", "2010");
                this.put("second", "bob");
            }
        });
    }

    protected CatalogPartitionSpec createPartitionSpecSubset() {
        return new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("second", "bob");
            }
        });
    }

    protected CatalogPartitionSpec createAnotherPartitionSpecSubset() {
        return new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("third", "2000");
            }
        });
    }

    protected CatalogPartitionSpec createInvalidPartitionSpecSubset() {
        return new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("third", "2010");
            }
        });
    }

    protected void checkEquals(CatalogFunction f1, CatalogFunction f2) {
        Assert.assertEquals((Object)f1.getClassName(), (Object)f2.getClassName());
        Assert.assertEquals((Object)f1.isGeneric(), (Object)f2.isGeneric());
        Assert.assertEquals((Object)f1.getFunctionLanguage(), (Object)f2.getFunctionLanguage());
    }

    protected void checkEquals(CatalogColumnStatistics cs1, CatalogColumnStatistics cs2) {
        CatalogTestUtil.checkEquals(cs1, cs2);
    }

    public static class TestTable
    implements CatalogView {
        public Map<String, String> getOptions() {
            return null;
        }

        public TableSchema getSchema() {
            return TableSchema.builder().build();
        }

        public String getComment() {
            return null;
        }

        public CatalogBaseTable copy() {
            return null;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }

        public String getOriginalQuery() {
            return "";
        }

        public String getExpandedQuery() {
            return "";
        }
    }
}

