/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.utils;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.types.RowKind;
import org.junit.Assert;
import org.junit.Test;

public class JoinedRowDataTest {
    @Test
    public void testJoinedRows() {
        GenericRowData row1 = GenericRowData.of((Object[])new Object[]{1L, 2L});
        GenericRowData row2 = GenericRowData.of((Object[])new Object[]{3L, StringData.fromString((String)"4")});
        JoinedRowData joinedRow = new JoinedRowData((RowData)row1, (RowData)row2);
        Assert.assertEquals((Object)RowKind.INSERT, (Object)joinedRow.getRowKind());
        Assert.assertEquals((long)4L, (long)joinedRow.getArity());
        Assert.assertEquals((long)1L, (long)joinedRow.getLong(0));
        Assert.assertEquals((long)2L, (long)joinedRow.getLong(1));
        Assert.assertEquals((long)3L, (long)joinedRow.getLong(2));
        Assert.assertEquals((Object)"4", (Object)joinedRow.getString(3).toString());
    }

    @Test
    public void testJoinedRowKind() {
        JoinedRowData joinedRow = new JoinedRowData(RowKind.DELETE, (RowData)GenericRowData.of((Object[])new Object[0]), (RowData)GenericRowData.of((Object[])new Object[0]));
        Assert.assertEquals((Object)RowKind.DELETE, (Object)joinedRow.getRowKind());
    }

    @Test
    public void testReplace() {
        GenericRowData row1 = GenericRowData.of((Object[])new Object[]{1L});
        GenericRowData row2 = GenericRowData.of((Object[])new Object[]{2L});
        JoinedRowData joinedRow = new JoinedRowData((RowData)row1, (RowData)row2);
        Assert.assertEquals((long)2L, (long)joinedRow.getArity());
        joinedRow.replace((RowData)GenericRowData.of((Object[])new Object[]{3L}), (RowData)GenericRowData.of((Object[])new Object[]{4L, 5L}));
        Assert.assertEquals((long)3L, (long)joinedRow.getArity());
        Assert.assertEquals((long)3L, (long)joinedRow.getLong(0));
        Assert.assertEquals((long)4L, (long)joinedRow.getLong(1));
        Assert.assertEquals((long)5L, (long)joinedRow.getLong(2));
    }
}

