/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestCatalogFactory;
import org.apache.flink.table.factories.TestConflictingDynamicTableFactory1;
import org.apache.flink.table.factories.TestConflictingDynamicTableFactory2;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.TestFormatFactory;
import org.apache.flink.table.factories.utils.FactoryMocks;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FactoryUtilTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMissingConnector() {
        this.expectError("Table options do not contain an option key 'connector' for discovering a connector.");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("connector");
        });
    }

    @Test
    public void testInvalidConnector() {
        this.expectError("Could not find any factory for identifier 'FAIL' that implements '" + DynamicTableFactory.class.getName() + "' in the classpath.\n\nAvailable factory identifiers are:\n\nconflicting\nsink-only\nsource-only\ntest\ntest-connector");
        FactoryUtilTest.testError(options -> options.put("connector", "FAIL"));
    }

    @Test
    public void testConflictingConnector() {
        this.expectError("Multiple factories for identifier 'conflicting' that implement '" + DynamicTableFactory.class.getName() + "' found in the classpath.\n\nAmbiguous factory classes are:\n\n" + TestConflictingDynamicTableFactory1.class.getName() + "\n" + TestConflictingDynamicTableFactory2.class.getName());
        FactoryUtilTest.testError(options -> options.put("connector", "conflicting"));
    }

    @Test
    public void testMissingConnectorOption() {
        this.expectError("One or more required options are missing.\n\nMissing required options are:\n\ntarget");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("target");
        });
    }

    @Test
    public void testInvalidConnectorOption() {
        this.expectError("Invalid value for option 'buffer-size'.");
        FactoryUtilTest.testError(options -> options.put("buffer-size", "FAIL"));
    }

    @Test
    public void testMissingFormat() {
        this.expectError("Could not find required scan format 'value.format'.");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("value.format");
        });
    }

    @Test
    public void testInvalidFormat() {
        this.expectError("Could not find any factory for identifier 'FAIL' that implements '" + DeserializationFormatFactory.class.getName() + "' in the classpath.\n\nAvailable factory identifiers are:\n\ntest-format");
        FactoryUtilTest.testError(options -> options.put("value.format", "FAIL"));
    }

    @Test
    public void testMissingFormatOption() {
        this.expectError("Error creating scan format 'test-format' in option space 'key.test-format.'.");
        this.expectError("One or more required options are missing.\n\nMissing required options are:\n\ndelimiter");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("key.test-format.delimiter");
        });
    }

    @Test
    public void testInvalidFormatOption() {
        this.expectError("Invalid value for option 'fail-on-missing'.");
        FactoryUtilTest.testError(options -> options.put("key.test-format.fail-on-missing", "FAIL"));
    }

    @Test
    public void testUnconsumedOption() {
        this.expectError("Unsupported options found for 'test-connector'.\n\nUnsupported options:\n\nthis-is-also-not-consumed\nthis-is-not-consumed\n\nSupported options:\n\nbuffer-size\nconnector\ndeprecated-target (deprecated)\nfallback-buffer-size\nformat\nkey.format\nkey.test-format.changelog-mode\nkey.test-format.delimiter\nkey.test-format.deprecated-delimiter (deprecated)\nkey.test-format.fail-on-missing\nkey.test-format.fallback-fail-on-missing\nkey.test-format.readable-metadata\nproperty-version\ntarget\nvalue.format\nvalue.test-format.changelog-mode\nvalue.test-format.delimiter\nvalue.test-format.deprecated-delimiter (deprecated)\nvalue.test-format.fail-on-missing\nvalue.test-format.fallback-fail-on-missing\nvalue.test-format.readable-metadata");
        FactoryUtilTest.testError(options -> {
            options.put("this-is-not-consumed", "42");
            options.put("this-is-also-not-consumed", "true");
        });
    }

    @Test
    public void testAllOptions() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        DynamicTableSource actualSource = FactoryMocks.createTableSource(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryMocks.createTableSink(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testDiscoveryForSeparateSourceSinkFactory() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.put("connector", "test");
        DynamicTableSource actualSource = FactoryMocks.createTableSource(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryMocks.createTableSink(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testOptionalFormat() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.remove("key.format");
        options.remove("key.test-format.delimiter");
        DynamicTableSource actualSource = FactoryMocks.createTableSource(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", null, new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryMocks.createTableSink(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, null, new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testAlternativeValueFormat() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.remove("value.format");
        options.remove("value.test-format.delimiter");
        options.remove("value.test-format.fail-on-missing");
        options.put("format", "test-format");
        options.put("test-format.delimiter", ";");
        options.put("test-format.fail-on-missing", "true");
        DynamicTableSource actualSource = FactoryMocks.createTableSource(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock(";", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryMocks.createTableSink(FactoryMocks.SCHEMA, options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock(";"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testConnectorErrorHint() {
        String errorMsg;
        try {
            FactoryMocks.createTableSource(FactoryMocks.SCHEMA, Collections.singletonMap("connector", "sink-only"));
            Assert.fail();
        }
        catch (Exception e) {
            errorMsg = "Connector 'sink-only' can only be used as a sink. It cannot be used as a source.";
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsCause((Throwable)new ValidationException(errorMsg)));
        }
        try {
            FactoryMocks.createTableSink(FactoryMocks.SCHEMA, Collections.singletonMap("connector", "source-only"));
            Assert.fail();
        }
        catch (Exception e) {
            errorMsg = "Connector 'source-only' can only be used as a source. It cannot be used as a sink.";
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsCause((Throwable)new ValidationException(errorMsg)));
        }
    }

    @Test
    public void testRequiredPlaceholderOption() {
        HashSet<ConfigOption> requiredOptions = new HashSet<ConfigOption>();
        requiredOptions.add(ConfigOptions.key((String)"fields.#.min").intType().noDefaultValue());
        requiredOptions.add(ConfigOptions.key((String)"no.placeholder.anymore").intType().noDefaultValue().withFallbackKeys(new String[]{"old.fields.#.min"}));
        FactoryUtil.validateFactoryOptions(requiredOptions, new HashSet(), (ReadableConfig)new Configuration());
    }

    @Test
    public void testCreateCatalog() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "test-catalog");
        options.put(TestCatalogFactory.DEFAULT_DATABASE.key(), "my-database");
        Catalog catalog = FactoryUtil.createCatalog((String)"my-catalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertTrue((boolean)(catalog instanceof TestCatalogFactory.TestCatalog));
        TestCatalogFactory.TestCatalog testCatalog = (TestCatalogFactory.TestCatalog)catalog;
        Assert.assertEquals((Object)testCatalog.getName(), (Object)"my-catalog");
        Assert.assertEquals((Object)testCatalog.getOptions().get(TestCatalogFactory.DEFAULT_DATABASE.key()), (Object)"my-database");
    }

    @Test
    public void testCatalogFactoryHelper() {
        FactoryUtil.CatalogFactoryHelper helper1 = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)new TestCatalogFactory(), (CatalogFactory.Context)new FactoryUtil.DefaultCatalogContext("test", Collections.emptyMap(), null, Thread.currentThread().getContextClassLoader()));
        helper1.validate();
        FactoryUtil.CatalogFactoryHelper helper2 = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)new TestCatalogFactory(), (CatalogFactory.Context)new FactoryUtil.DefaultCatalogContext("test", Collections.singletonMap("x", "y"), null, Thread.currentThread().getContextClassLoader()));
        this.expectError("Unsupported options found for 'test-catalog'");
        helper2.validate();
    }

    @Test
    public void testFactoryHelperWithDeprecatedOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("deprecated-target", "MyTarget");
        options.put("fallback-buffer-size", "1000");
        options.put("value.format", "test-format");
        options.put("value.test-format.deprecated-delimiter", "|");
        options.put("value.test-format.fallback-fail-on-missing", "true");
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)new TestDynamicTableFactory(), (DynamicTableFactory.Context)FactoryMocks.createTableContext(FactoryMocks.SCHEMA, options));
        helper.discoverDecodingFormat(DeserializationFormatFactory.class, TestDynamicTableFactory.VALUE_FORMAT);
        helper.validate();
    }

    @Test
    public void testFactoryHelperWithMapOption() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("properties.prop-1", "value-1");
        options.put("properties.prop-2", "value-2");
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)new TestFactoryWithMap(), (DynamicTableFactory.Context)FactoryMocks.createTableContext(FactoryMocks.SCHEMA, options));
        helper.validate();
    }

    @Test
    public void testInvalidFactoryHelperWithMapOption() {
        this.expectError("Unsupported options found for 'test-factory-with-map'.\n\nUnsupported options:\n\nunknown\n\nSupported options:\n\nconnector\nproperties\nproperties.prop-1\nproperties.prop-2\nproperty-version");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("properties.prop-1", "value-1");
        options.put("properties.prop-2", "value-2");
        options.put("unknown", "value-3");
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)new TestFactoryWithMap(), (DynamicTableFactory.Context)FactoryMocks.createTableContext(FactoryMocks.SCHEMA, options));
        helper.validate();
    }

    private void expectError(String message) {
        this.thrown.expect(ValidationException.class);
        this.thrown.expect(FlinkMatchers.containsMessage((String)message));
    }

    private static void testError(Consumer<Map<String, String>> optionModifier) {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        optionModifier.accept(options);
        FactoryMocks.createTableSource(FactoryMocks.SCHEMA, options);
    }

    private static Map<String, String> createAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("property-version", "1");
        options.put("connector", "test-connector");
        options.put("target", "MyTarget");
        options.put("buffer-size", "1000");
        options.put("key.format", "test-format");
        options.put("key.test-format.delimiter", ",");
        options.put("value.format", "test-format");
        options.put("value.test-format.delimiter", "|");
        options.put("value.test-format.fail-on-missing", "true");
        return options;
    }

    private static class TestFactoryWithMap
    implements DynamicTableFactory {
        public static final ConfigOption<Map<String, String>> PROPERTIES = ConfigOptions.key((String)"properties").mapType().noDefaultValue();

        private TestFactoryWithMap() {
        }

        public String factoryIdentifier() {
            return "test-factory-with-map";
        }

        public Set<ConfigOption<?>> requiredOptions() {
            return Collections.emptySet();
        }

        public Set<ConfigOption<?>> optionalOptions() {
            return Collections.singleton(PROPERTIES);
        }
    }
}

