/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LegacyTypeInfoDataTypeConverterTest {
    @Parameterized.Parameter
    public TypeInformation<?> inputTypeInfo;
    @Parameterized.Parameter(value=1)
    public DataType dataType;

    @Parameterized.Parameters(name="[{index}] type info: {0} data type: {1}")
    public static List<Object[]> typeInfo() {
        return Arrays.asList({Types.STRING, DataTypes.STRING()}, {Types.STRING, DataTypes.STRING().notNull()}, {Types.BOOLEAN, DataTypes.BOOLEAN()}, {Types.SQL_TIMESTAMP, DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)}, {Types.GENERIC(LegacyTypeInfoDataTypeConverterTest.class), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.RAW, Types.GENERIC(LegacyTypeInfoDataTypeConverterTest.class)))}, {Types.ROW_NAMED((String[])new String[]{"field1", "field2"}, (TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BIGINT())})}, {Types.MAP((TypeInformation)Types.FLOAT, (TypeInformation)Types.ROW((TypeInformation[])new TypeInformation[]{Types.BYTE})), DataTypes.MAP((DataType)DataTypes.FLOAT(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.TINYINT())}))}, {Types.PRIMITIVE_ARRAY((TypeInformation)Types.FLOAT), DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE))).bridgedTo(float[].class)}, {Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), DataTypes.BYTES()}, {Types.OBJECT_ARRAY((TypeInformation)Types.PRIMITIVE_ARRAY((TypeInformation)Types.FLOAT)), DataTypes.ARRAY((DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE))).bridgedTo(float[].class))).bridgedTo(float[][].class)}, {BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.ARRAY, (TypeInformation)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO))}, {ObjectArrayTypeInfo.getInfoFor((TypeInformation)Types.STRING), DataTypes.ARRAY((DataType)DataTypes.STRING()).bridgedTo(String[].class)}, {Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.SHORT, Types.DOUBLE, Types.FLOAT}), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.STRUCTURED_TYPE, Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.SHORT, Types.DOUBLE, Types.FLOAT})))}, {TimeIndicatorTypeInfo.ROWTIME_INDICATOR, new AtomicDataType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)).bridgedTo(Timestamp.class)}, {TimeIndicatorTypeInfo.PROCTIME_INDICATOR, new AtomicDataType((LogicalType)new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3)).bridgedTo(Instant.class)});
    }

    @Test
    public void testTypeInfoToDataTypeConversion() {
        Assert.assertThat((Object)LegacyTypeInfoDataTypeConverter.toDataType(this.inputTypeInfo), (Matcher)CoreMatchers.equalTo((Object)this.dataType.nullable()));
    }

    @Test
    public void testDataTypeToTypeInfoConversion() {
        Assert.assertThat((Object)LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)this.dataType), (Matcher)CoreMatchers.equalTo(this.inputTypeInfo));
    }
}

