/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.junit.runners.Parameterized;

public class TypeStrategiesTest
extends TypeStrategiesTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TypeStrategiesTestBase.TestSpec> testData() {
        return Arrays.asList(TypeStrategiesTestBase.TestSpec.forStrategy(TypeStrategies.MISSING).inputTypes(DataTypes.INT()).expectErrorMessage("Could not infer an output type for the given arguments."), TypeStrategiesTestBase.TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.BIGINT())).inputTypes(new DataType[0]).expectDataType(DataTypes.BIGINT()), TypeStrategiesTestBase.TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(DataTypes.INT(), DataTypes.STRING()).expectDataType(DataTypes.INT()), TypeStrategiesTestBase.TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments."), TypeStrategiesTestBase.TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.NULL())).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments. Untyped NULL received."), TypeStrategiesTestBase.TestSpec.forStrategy("First type strategy", TypeStrategies.first((TypeStrategy[])new TypeStrategy[]{callContext -> Optional.empty(), TypeStrategies.explicit((DataType)DataTypes.INT())})).inputTypes(new DataType[0]).expectDataType(DataTypes.INT()), TypeStrategiesTestBase.TestSpec.forStrategy("Match root type strategy", TypeStrategies.matchFamily((int)0, (LogicalTypeFamily)LogicalTypeFamily.NUMERIC)).inputTypes(DataTypes.INT()).expectDataType(DataTypes.INT()), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid match root type strategy", TypeStrategies.matchFamily((int)0, (LogicalTypeFamily)LogicalTypeFamily.NUMERIC)).inputTypes(DataTypes.BOOLEAN()).expectErrorMessage("Could not infer an output type for the given arguments."), TypeStrategiesTestBase.TestSpec.forStrategy("Cascading to nullable type", TypeStrategies.nullableIfArgs((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().notNull())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Cascading to not null type", TypeStrategies.nullableIfArgs((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).notNull()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Cascading to not null type but only consider first argument", TypeStrategies.nullableIfArgs((ConstantArgumentCount)ConstantArgumentCount.to((int)0), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Cascading to null type but only consider first two argument", TypeStrategies.nullableIfArgs((ConstantArgumentCount)ConstantArgumentCount.to((int)1), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Cascading to not null type but only consider the second and third argument", TypeStrategies.nullableIfArgs((ConstantArgumentCount)ConstantArgumentCount.between((int)1, (int)2), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().nullable(), (DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).notNull()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Find a common type", TypeStrategies.COMMON).inputTypes(DataTypes.INT(), (DataType)DataTypes.TINYINT().notNull(), DataTypes.DECIMAL((int)20, (int)10)).expectDataType(DataTypes.DECIMAL((int)20, (int)10)), TypeStrategiesTestBase.TestSpec.forStrategy("Convert to varying string", TypeStrategies.varyingString((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.CHAR((int)12).notNull())))).inputTypes((DataType)DataTypes.CHAR((int)12).notNull()).expectDataType((DataType)DataTypes.VARCHAR((int)12).notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Average with grouped aggregation", TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, (boolean)true)).inputTypes((DataType)DataTypes.INT().notNull()).calledWithGroupedAggregation().expectDataType((DataType)DataTypes.INT().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Average without grouped aggregation", TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, (boolean)true)).inputTypes((DataType)DataTypes.INT().notNull()).expectDataType(DataTypes.INT()));
    }
}

