/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Assert;
import org.junit.Test;

public class PrintUtilsTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");

    @Test
    public void testArrayToString() {
        Row row = new Row(7);
        row.setField(0, (Object)new int[]{1, 2});
        row.setField(1, (Object)new Integer[]{3, 4});
        row.setField(2, (Object)new Object[]{new int[]{5, 6}, new int[]{7, 8}});
        row.setField(3, (Object)new Integer[][]{{9, 10}, {11, 12}});
        row.setField(4, (Object)new LocalDateTime[]{LocalDateTime.parse("2021-04-18T18:00:00.123456"), LocalDateTime.parse("2021-04-18T18:00:00.000001")});
        row.setField(5, (Object)new Instant[][]{{Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L)}, {Instant.ofEpochSecond(1L), Instant.ofEpochSecond(10L)}});
        row.setField(6, (Object)new int[]{1123, 2123});
        ResolvedSchema resolvedSchema = ResolvedSchema.of(Arrays.asList(Column.physical((String)"f0", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), Column.physical((String)"f1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), Column.physical((String)"f2", (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))), Column.physical((String)"f3", (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))), Column.physical((String)"f4", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP((int)6))), Column.physical((String)"f5", (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_LTZ((int)3)))), Column.physical((String)"f6", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME()))));
        Assert.assertEquals((Object)"[[1, 2], [3, 4], [[5, 6], [7, 8]], [[9, 10], [11, 12]], [2021-04-18 18:00:00.123456, 2021-04-18 18:00:00.000001], [[1970-01-01 00:00:00.001, 1970-01-01 00:00:00.010], [1970-01-01 00:00:01.000, 1970-01-01 00:00:10.000]], [00:00:01, 00:00:02]]", (Object)Arrays.toString(PrintUtils.rowToString((Row)row, (ResolvedSchema)resolvedSchema, (ZoneId)UTC_ZONE_ID)));
    }

    @Test
    public void testNestedRowToString() {
        Row row = new Row(4);
        row.setField(0, (Object)new int[]{1, 2});
        Row row1 = new Row(4);
        row1.setField(0, (Object)"hello");
        row1.setField(1, (Object)new boolean[]{true, false});
        row1.setField(2, (Object)new Timestamp[]{Timestamp.valueOf("2021-04-18 18:00:00.123456"), Timestamp.valueOf("2021-04-18 18:00:00.000001")});
        row1.setField(3, (Object)new Long[]{100L, 200L});
        row.setField(1, (Object)row1);
        row.setField(2, (Object)new int[][]{{1, 10}, {2, 20}});
        row.setField(3, (Object)new Integer[]{3000, 4000});
        ResolvedSchema resolvedSchema = ResolvedSchema.of(Arrays.asList(Column.physical((String)"f0", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), Column.physical((String)"f1", (DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()), DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP((int)6)), DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_LTZ((int)6))})), Column.physical((String)"f2", (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))), Column.physical((String)"f3", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME()))));
        Assert.assertEquals((Object)"[[1, 2], +I[hello, [true, false], [2021-04-18 18:00:00.123456, 2021-04-18 18:00:00.000001], [1970-01-01 00:00:00.100000, 1970-01-01 00:00:00.200000]], [[1, 10], [2, 20]], [00:00:03, 00:00:04]]", (Object)Arrays.toString(PrintUtils.rowToString((Row)row, (ResolvedSchema)resolvedSchema, (ZoneId)UTC_ZONE_ID)));
    }

    @Test
    public void testNestedMapToString() {
        Row row = new Row(2);
        row.setField(0, (Object)new int[]{1, 2});
        Row row1 = new Row(2);
        row1.setField(0, (Object)"hello");
        HashMap<TimestampData, TimestampData> map = new HashMap<TimestampData, TimestampData>();
        map.put(TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)2000L));
        map.put(TimestampData.fromEpochMillis((long)2000L), TimestampData.fromEpochMillis((long)4000L));
        row1.setField(1, map);
        row.setField(1, (Object)row1);
        ResolvedSchema resolvedSchema = ResolvedSchema.of(Arrays.asList(Column.physical((String)"f0", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), Column.physical((String)"f1", (DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.MAP((DataType)DataTypes.TIMESTAMP_LTZ((int)3), (DataType)DataTypes.TIMESTAMP_LTZ((int)3))}))));
        Assert.assertEquals((Object)"[[1, 2], +I[hello, {1970-01-01 00:00:01.000=1970-01-01 00:00:02.000, 1970-01-01 00:00:02.000=1970-01-01 00:00:04.000}]]", (Object)Arrays.toString(PrintUtils.rowToString((Row)row, (ResolvedSchema)resolvedSchema, (ZoneId)UTC_ZONE_ID)));
    }

    @Test
    public void testCharFullWidth() {
        char[] chars = new char[]{'A', 'a', ',', '\u4e2d', '\uff0c', '\u3053'};
        boolean[] expected = new boolean[]{false, false, false, true, true, true};
        for (int i = 0; i < chars.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)PrintUtils.isFullWidth((int)Character.codePointAt(chars, i)));
        }
    }

    @Test
    public void testStringDisplayWidth() {
        List<String> data = Arrays.asList("abcdefg,12345,ABC", "to be or not to be that's a question.", "\u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587", "\u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f\u3081\u306e\u6587\u3067\u3059");
        int[] expected = new int[]{17, 37, 12, 36};
        for (int i = 0; i < data.size(); ++i) {
            Assert.assertEquals((long)expected[i], (long)PrintUtils.getStringDisplayWidth((String)data.get(i)));
        }
    }

    @Test
    public void testPrintWithEmptyResult() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), Collections.emptyList().iterator(), (PrintWriter)new PrintWriter(this.outContent), (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("Empty set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void testPrintWithEmptyResultAndRowKind() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), Collections.emptyList().iterator(), (PrintWriter)new PrintWriter(this.outContent), (int)30, (String)"", (boolean)true, (boolean)true, (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("Empty set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void testPrintWithEmptyResultAndDeriveColumnWidthByContent() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), Collections.emptyList().iterator(), (PrintWriter)new PrintWriter(this.outContent), (int)30, (String)"", (boolean)false, (boolean)false, (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("Empty set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void testPrintWithMultipleRows() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), this.getData().iterator(), (PrintWriter)new PrintWriter(this.outContent), (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| boolean |         int |               bigint |                        varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "|  (NULL) |           1 |                    2 |                            abc |           1.23 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "|   false |      (NULL) |                    0 |                                |              1 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "|    true |  2147483647 |               (NULL) |                        abcdefg |     1234567890 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "|   false | -2147483648 |  9223372036854775807 |                         (NULL) |    12345.06789 | 2020-03-01 18:39:14.123000 |" + System.lineSeparator() + "|    true |         100 | -9223372036854775808 |                     abcdefg111 |         (NULL) | 2020-03-01 18:39:14.123456 |" + System.lineSeparator() + "|  (NULL) |          -1 |                   -1 | abcdefghijklmnopqrstuvwxyza... |   -12345.06789 |                     (NULL) |" + System.lineSeparator() + "|  (NULL) |          -1 |                   -1 |                   \u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587 |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "|  (NULL) |          -1 |                   -1 |  \u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f... |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "8 rows in set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void testPrintWithMultipleRowsAndRowKind() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), this.getData().iterator(), (PrintWriter)new PrintWriter(this.outContent), (int)30, (String)"", (boolean)true, (boolean)true, (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| op | boolean |         int |               bigint |                        varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| +I |         |           1 |                    2 |                            abc |           1.23 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "| +I |   false |             |                    0 |                                |              1 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "| -D |    true |  2147483647 |                      |                        abcdefg |     1234567890 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "| +I |   false | -2147483648 |  9223372036854775807 |                                |    12345.06789 | 2020-03-01 18:39:14.123000 |" + System.lineSeparator() + "| +I |    true |         100 | -9223372036854775808 |                     abcdefg111 |                | 2020-03-01 18:39:14.123456 |" + System.lineSeparator() + "| -U |         |          -1 |                   -1 | abcdefghijklmnopqrstuvwxyza... |   -12345.06789 |                            |" + System.lineSeparator() + "| +U |         |          -1 |                   -1 |                   \u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587 |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "| -D |         |          -1 |                   -1 |  \u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f... |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "8 rows in set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void testPrintWithMultipleRowsAndDeriveColumnWidthByContent() {
        PrintUtils.printAsTableauForm((ResolvedSchema)this.getSchema(), this.getData().subList(0, 3).iterator(), (PrintWriter)new PrintWriter(this.outContent), (int)30, (String)"", (boolean)false, (boolean)true, (ZoneId)UTC_ZONE_ID);
        Assert.assertEquals((Object)("+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "| op | boolean |        int | bigint | varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "| +I |         |          1 |      2 |     abc |           1.23 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "| +I |   false |            |      0 |         |              1 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "| -D |    true | 2147483647 |        | abcdefg |     1234567890 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "3 rows in set" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    private ResolvedSchema getSchema() {
        return ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"boolean", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"int", (DataType)DataTypes.INT()), Column.physical((String)"bigint", (DataType)DataTypes.BIGINT()), Column.physical((String)"varchar", (DataType)DataTypes.STRING()), Column.physical((String)"decimal(10, 5)", (DataType)DataTypes.DECIMAL((int)10, (int)5)), Column.physical((String)"timestamp", (DataType)DataTypes.TIMESTAMP((int)6))});
    }

    private List<Row> getData() {
        ArrayList<Row> data = new ArrayList<Row>();
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null, 1, 2, "abc", BigDecimal.valueOf(1.23), Timestamp.valueOf("2020-03-01 18:39:14")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{false, null, 0, "", BigDecimal.valueOf(1L), Timestamp.valueOf("2020-03-01 18:39:14.1")}));
        data.add(Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{true, Integer.MAX_VALUE, null, "abcdefg", BigDecimal.valueOf(1234567890L), Timestamp.valueOf("2020-03-01 18:39:14.12")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{false, Integer.MIN_VALUE, Long.MAX_VALUE, null, BigDecimal.valueOf(12345.06789), Timestamp.valueOf("2020-03-01 18:39:14.123")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, 100, Long.MIN_VALUE, "abcdefg111", null, Timestamp.valueOf("2020-03-01 18:39:14.123456")}));
        data.add(Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{null, -1, -1, "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz", BigDecimal.valueOf(-12345.06789), null}));
        data.add(Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{null, -1, -1, "\u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587", BigDecimal.valueOf(-12345.06789), Timestamp.valueOf("2020-03-04 18:39:14")}));
        data.add(Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{null, -1, -1, "\u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f\u3081\u306e\u6587\u3067\u3059", BigDecimal.valueOf(-12345.06789), Timestamp.valueOf("2020-03-04 18:39:14")}));
        return data;
    }
}

