/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSchemaTest {
    private static final String WATERMARK_EXPRESSION = "localtimestamp";
    private static final String WATERMARK_EXPRESSION_TS_LTZ = "now()";
    private static final DataType WATERMARK_DATATYPE = DataTypes.TIMESTAMP((int)3);
    private static final DataType WATERMARK_TS_LTZ_DATATYPE = DataTypes.TIMESTAMP_LTZ((int)3);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableSchema() {
        TableSchema schema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"f0", (DataType)DataTypes.BIGINT())).add((TableColumn)TableColumn.physical((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))}))).add((TableColumn)TableColumn.physical((String)"f2", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.computed((String)"f3", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")).add((TableColumn)TableColumn.metadata((String)"f4", (DataType)DataTypes.BIGINT(), (String)"other.key", (boolean)true)).watermark("f1.q2", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
        String expected = "root\n |-- f0: BIGINT\n |-- f1: ROW<`q1` STRING, `q2` TIMESTAMP(3)>\n |-- f2: STRING\n |-- f3: BIGINT AS f0 + 1\n |-- f4: BIGINT METADATA FROM 'other.key' VIRTUAL\n |-- WATERMARK FOR f1.q2: TIMESTAMP(3) AS localtimestamp\n";
        Assertions.assertThat((String)schema.toString()).isEqualTo(expected);
        Assertions.assertThat((Optional)schema.getFieldName(2)).isEqualTo(Optional.of("f2"));
        Assertions.assertThat((Optional)schema.getFieldDataType(3)).isEqualTo(Optional.of(DataTypes.BIGINT()));
        Assertions.assertThat((Optional)schema.getTableColumn(3)).isEqualTo(Optional.of(TableColumn.computed((String)"f3", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")));
        Assertions.assertThat((Optional)schema.getFieldDataType("f2")).isEqualTo(Optional.of(DataTypes.STRING()));
        Assertions.assertThat(schema.getFieldDataType("f1").map(r -> (DataType)r.getChildren().get(0))).isEqualTo(Optional.of(DataTypes.STRING()));
        Assertions.assertThat((Optional)schema.getFieldName(5)).isNotPresent();
        Assertions.assertThat((Optional)schema.getFieldType(-1)).isNotPresent();
        Assertions.assertThat((Optional)schema.getFieldType("c")).isNotPresent();
        Assertions.assertThat((Optional)schema.getFieldDataType("f1.q1")).isNotPresent();
        Assertions.assertThat((Optional)schema.getFieldDataType("f1.q3")).isNotPresent();
        Assertions.assertThat((Object)schema.copy()).isEqualTo((Object)schema);
        Assertions.assertThat((int)schema.copy().hashCode()).isEqualTo(schema.hashCode());
    }

    @Test
    public void testWatermarkOnTimestampLtz() {
        TableSchema tableSchema = TableSchema.builder().field("f0", DataTypes.TIMESTAMP()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP_LTZ((int)3))})).watermark("f1.q2", WATERMARK_EXPRESSION_TS_LTZ, WATERMARK_TS_LTZ_DATATYPE).build();
        String expected = "root\n |-- f0: TIMESTAMP(6)\n |-- f1: ROW<`q1` STRING, `q2` TIMESTAMP_LTZ(3)>\n |-- WATERMARK FOR f1.q2: TIMESTAMP_LTZ(3) AS now()\n";
        Assertions.assertThat((String)tableSchema.toString()).isEqualTo(expected);
    }

    @Test
    public void testPersistedRowDataType() {
        TableSchema schema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"f0", (DataType)DataTypes.BIGINT())).add((TableColumn)TableColumn.metadata((String)"f1", (DataType)DataTypes.BIGINT(), (boolean)true)).add((TableColumn)TableColumn.metadata((String)"f2", (DataType)DataTypes.BIGINT(), (boolean)false)).add((TableColumn)TableColumn.physical((String)"f3", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.computed((String)"f4", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")).add((TableColumn)TableColumn.metadata((String)"f5", (DataType)DataTypes.BIGINT(), (boolean)false)).build();
        DataType expectedDataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f5", (DataType)DataTypes.BIGINT())}).notNull();
        Assertions.assertThat((Object)schema.toPersistedRowDataType()).isEqualTo((Object)expectedDataType);
    }

    @Test
    public void testPhysicalRowDataType() {
        TableSchema schema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"f0", (DataType)DataTypes.BIGINT())).add((TableColumn)TableColumn.metadata((String)"f1", (DataType)DataTypes.BIGINT(), (boolean)true)).add((TableColumn)TableColumn.metadata((String)"f2", (DataType)DataTypes.BIGINT(), (boolean)false)).add((TableColumn)TableColumn.physical((String)"f3", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.computed((String)"f4", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")).add((TableColumn)TableColumn.metadata((String)"f5", (DataType)DataTypes.BIGINT(), (boolean)false)).build();
        DataType expectedDataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.STRING())}).notNull();
        Assertions.assertThat((Object)schema.toPhysicalRowDataType()).isEqualTo((Object)expectedDataType);
    }

    @Test
    public void testRowDataType() {
        TableSchema schema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"f0", (DataType)DataTypes.BIGINT())).add((TableColumn)TableColumn.metadata((String)"f1", (DataType)DataTypes.BIGINT(), (boolean)true)).add((TableColumn)TableColumn.metadata((String)"f2", (DataType)DataTypes.BIGINT(), (boolean)false)).add((TableColumn)TableColumn.physical((String)"f3", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.computed((String)"f4", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")).add((TableColumn)TableColumn.metadata((String)"f5", (DataType)DataTypes.BIGINT(), (boolean)false)).build();
        DataType expectedDataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f4", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f5", (DataType)DataTypes.BIGINT())}).notNull();
        Assertions.assertThat((Object)schema.toRowDataType()).isEqualTo((Object)expectedDataType);
    }

    @Test
    public void testWatermarkOnDifferentFields() {
        ArrayList<Tuple3> testData = new ArrayList<Tuple3>();
        testData.add(Tuple3.of((Object)"a", (Object)DataTypes.BIGINT(), (Object)"but is of type 'BIGINT'"));
        testData.add(Tuple3.of((Object)"b", (Object)DataTypes.STRING(), (Object)"but is of type 'STRING'"));
        testData.add(Tuple3.of((Object)"c", (Object)DataTypes.INT(), (Object)"but is of type 'INT'"));
        testData.add(Tuple3.of((Object)"d", (Object)DataTypes.TIMESTAMP(), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"e", (Object)DataTypes.TIMESTAMP((int)0), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"f", (Object)DataTypes.TIMESTAMP((int)3), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"g", (Object)DataTypes.TIMESTAMP((int)9), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"h", (Object)DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3), (Object)"but is of type 'TIMESTAMP(3) WITH TIME ZONE'"));
        testData.forEach(t -> {
            TableSchema.Builder builder = TableSchema.builder();
            testData.forEach(e -> builder.field((String)e.f0, (DataType)e.f1));
            builder.watermark((String)t.f0, WATERMARK_EXPRESSION, WATERMARK_DATATYPE);
            if (((String)t.f2).equals("PASS")) {
                TableSchema schema = builder.build();
                Assertions.assertThat((List)schema.getWatermarkSpecs()).hasSize(1);
                Assertions.assertThat((String)((WatermarkSpec)schema.getWatermarkSpecs().get(0)).getRowtimeAttribute()).isEqualTo((String)t.f0);
            } else {
                try {
                    builder.build();
                }
                catch (Exception e2) {
                    Assertions.assertThat((String)e2.getMessage()).contains(new CharSequence[]{(CharSequence)t.f2});
                }
            }
        });
    }

    @Test
    public void testWatermarkOnNestedField() {
        TableSchema schema = TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"q3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"t1", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"t2", (DataType)DataTypes.STRING())}))})).watermark("f1.q3.t1", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
        Assertions.assertThat((List)schema.getWatermarkSpecs()).hasSize(1);
        Assertions.assertThat((String)((WatermarkSpec)schema.getWatermarkSpecs().get(0)).getRowtimeAttribute()).isEqualTo("f1.q3.t1");
    }

    @Test
    public void testWatermarkOnNonExistedField() {
        this.thrown.expectMessage("Rowtime attribute 'f1.q0' is not defined in schema");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))})).watermark("f1.q0", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
    }

    @Test
    public void testMultipleWatermarks() {
        this.thrown.expectMessage("Multiple watermark definition is not supported yet.");
        TableSchema.builder().field("f0", DataTypes.TIMESTAMP()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))})).watermark("f1.q2", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).watermark("f0", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
    }

    @Test
    public void testDifferentWatermarkStrategyOutputTypes() {
        ArrayList<Tuple2> testData = new ArrayList<Tuple2>();
        testData.add(Tuple2.of((Object)DataTypes.BIGINT(), (Object)"but is of type 'BIGINT'"));
        testData.add(Tuple2.of((Object)DataTypes.STRING(), (Object)"but is of type 'STRING'"));
        testData.add(Tuple2.of((Object)DataTypes.INT(), (Object)"but is of type 'INT'"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP(), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)0), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)3), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)9), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3), (Object)"but is of type 'TIMESTAMP(3) WITH TIME ZONE'"));
        testData.forEach(t -> {
            TableSchema.Builder builder = TableSchema.builder().field("f0", DataTypes.TIMESTAMP()).watermark("f0", "f0 - INTERVAL '5' SECOND", (DataType)t.f0);
            if (((String)t.f1).equals("PASS")) {
                TableSchema schema = builder.build();
                Assertions.assertThat((List)schema.getWatermarkSpecs()).hasSize(1);
            } else {
                try {
                    builder.build();
                }
                catch (Exception e) {
                    Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{(CharSequence)t.f1});
                }
            }
        });
    }

    @Test
    public void testPrimaryKeyPrinting() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
        Assertions.assertThat((String)schema.toString()).isEqualTo("root\n |-- f0: BIGINT NOT NULL\n |-- f1: STRING NOT NULL\n |-- f2: DOUBLE NOT NULL\n |-- CONSTRAINT pk PRIMARY KEY (f0, f2)\n");
    }

    @Test
    public void testPrimaryKeyColumnsIndices() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
        UniqueConstraint expectedKey = UniqueConstraint.primaryKey((String)"pk", Arrays.asList("f0", "f2"));
        Assertions.assertThat(schema.getPrimaryKey().get()).isEqualTo((Object)expectedKey);
    }

    @Test
    public void testPrimaryKeyLazilyDefinedColumns() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).build();
        UniqueConstraint expectedKey = UniqueConstraint.primaryKey((String)"pk", Arrays.asList("f0", "f2"));
        Assertions.assertThat(schema.getPrimaryKey().get()).isEqualTo((Object)expectedKey);
    }

    @Test
    public void testPrimaryKeyNoColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk'. Column 'f2' does not exist.");
        TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNullableColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk'. Column 'f0' is nullable.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("pk", new String[]{"f0"}).build();
    }

    @Test
    public void testPrimaryKeyGeneratedColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk'. Column 'f0' is not a physical column.");
        TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull(), "123").primaryKey("pk", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNameMustNotBeNull() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY's name can not be null or empty.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey(null, new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNameMustNotBeEmpty() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY's name can not be null or empty.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNoColumns() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY constraint must be defined for at least a single column.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("pk", new String[0]).build();
    }
}

