/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.utils;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.test.RowDataAssert;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProjectedRowDataTest {
    @Test
    public void testProjectedRows() {
        GenericRowData initialRow = GenericRowData.of((Object[])new Object[]{0L, 1L, 2L, 3L, 4L});
        ProjectedRowData projectedRowData = ProjectedRowData.from((int[][])new int[][]{{2}, {0}, {1}, {4}});
        RowDataAssert rowAssert = TableAssertions.assertThat((RowData)projectedRowData);
        projectedRowData.replaceRow((RowData)initialRow);
        rowAssert.hasKind(RowKind.INSERT).hasArity(4);
        rowAssert.getLong(0).isEqualTo(2L);
        rowAssert.getLong(1).isEqualTo(0L);
        rowAssert.getLong(2).isEqualTo(1L);
        rowAssert.getLong(3).isEqualTo(4L);
        projectedRowData.replaceRow((RowData)GenericRowData.of((Object[])new Object[]{5L, 6L, 7L, 8L, 9L, 10L}));
        rowAssert.hasKind(RowKind.INSERT).hasArity(4);
        rowAssert.getLong(0).isEqualTo(7L);
        rowAssert.getLong(1).isEqualTo(5L);
        rowAssert.getLong(2).isEqualTo(6L);
        rowAssert.getLong(3).isEqualTo(9L);
    }

    @Test
    public void testProjectedRowsDoesntSupportNestedProjections() {
        Assertions.assertThatThrownBy(() -> ProjectedRowData.from((int[][])new int[][]{{2}, {0, 1}, {1}, {4}})).isInstanceOf(IllegalArgumentException.class);
    }
}

