/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionTest {
    private static final ScalarFunction DUMMY_FUNCTION = new ScalarFunction(){};
    private static final Expression TREE_WITH_NULL = ExpressionTest.createExpressionTree(null);
    private static final Expression TREE_WITH_VALUE = ExpressionTest.createExpressionTree(12);
    private static final Expression TREE_WITH_SAME_VALUE = ExpressionTest.createExpressionTree(12);
    private static final String TREE_WITH_NULL_STRING = "and(true, equals(field, dummy(null)))";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExpressionString() {
        Assertions.assertThat((String)TREE_WITH_NULL.toString()).isEqualTo(TREE_WITH_NULL_STRING);
    }

    @Test
    public void testExpressionEquality() {
        Assertions.assertThat((Object)TREE_WITH_SAME_VALUE).isEqualTo((Object)TREE_WITH_VALUE);
    }

    @Test
    public void testArrayValueLiteralEquality() {
        Assertions.assertThat((Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}})).isEqualTo((Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}));
        Assertions.assertThat((Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull())).isEqualTo((Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull()));
        Assertions.assertThat((Object)new ValueLiteralExpression((Object)"abc".getBytes(StandardCharsets.UTF_8))).isEqualTo((Object)new ValueLiteralExpression((Object)"abc".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testExpressionInequality() {
        Assertions.assertThat((Object)TREE_WITH_VALUE).isNotEqualTo((Object)TREE_WITH_NULL);
    }

    @Test
    public void testValueLiteralString() {
        Assertions.assertThat((String)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}).toString()).isEqualTo("[null, null, [1, 2, 3]]");
        Assertions.assertThat((String)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull()).toString()).isEqualTo("[null, null, ['1', '2', '3', 'Dog''s']]");
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("key1", 1);
        map.put("key2", 2);
        map.put("key3", 3);
        Assertions.assertThat((String)new ValueLiteralExpression(map, (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()).notNull()).toString()).isEqualTo("{key1=1, key2=2, key3=3}");
        Assertions.assertThat((String)new ValueLiteralExpression(map, (DataType)DataTypes.MULTISET((DataType)DataTypes.STRING()).notNull()).toString()).isEqualTo("{key1=1, key2=2, key3=3}");
    }

    @Test
    public void testInvalidValueLiteral() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("does not support a value literal of class 'java.lang.Integer'");
        new ValueLiteralExpression((Object)12, (DataType)DataTypes.TINYINT().notNull());
    }

    @Test
    public void testInvalidValueLiteralExtraction() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Cannot derive a data type");
        new ValueLiteralExpression((Object)this);
    }

    @Test
    public void testBigDecimalValueLiteralExtraction() {
        float f = 2.4444444f;
        Assertions.assertThat((Float)new ValueLiteralExpression((Object)Float.valueOf(2.4444444f)).getValueAs(BigDecimal.class).map(BigDecimal::floatValue).orElseThrow(AssertionError::new)).isEqualTo(2.4444444f);
    }

    @Test
    public void testLocalDateTimeValueLiteralExtraction() {
        Timestamp sqlTimestamp = Timestamp.valueOf("2006-11-03 00:00:00.123456789");
        LocalDateTime localDateTime = LocalDateTime.of(2006, 11, 3, 0, 0, 0, 123456789);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)new ValueLiteralExpression((Object)sqlTimestamp).getValueAs(LocalDateTime.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localDateTime);
    }

    @Test
    public void testLocalTimeValueLiteralExtraction() {
        LocalTime localTime = LocalTime.of(12, 12, 12, 123456789);
        long nanos = localTime.toNanoOfDay();
        int millis = localTime.get(ChronoField.MILLI_OF_DAY);
        Time sqlTime = Time.valueOf("12:12:12");
        Assertions.assertThat((LocalTime)((LocalTime)new ValueLiteralExpression((Object)sqlTime).getValueAs(LocalTime.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localTime.withNano(0));
        Assertions.assertThat((LocalTime)((LocalTime)new ValueLiteralExpression((Object)nanos).getValueAs(LocalTime.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localTime);
        Assertions.assertThat((LocalTime)((LocalTime)new ValueLiteralExpression((Object)millis).getValueAs(LocalTime.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localTime.minusNanos(456789L));
    }

    @Test
    public void testLocalDateValueLiteralExtraction() {
        LocalDate localDate = LocalDate.of(2012, 12, 12);
        int daysSinceEpoch = (int)localDate.toEpochDay();
        Date sqlDate = Date.valueOf("2012-12-12");
        Assertions.assertThat((LocalDate)((LocalDate)new ValueLiteralExpression((Object)sqlDate).getValueAs(LocalDate.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localDate);
        Assertions.assertThat((LocalDate)((LocalDate)new ValueLiteralExpression((Object)daysSinceEpoch).getValueAs(LocalDate.class).orElseThrow(AssertionError::new))).isEqualTo((Object)localDate);
    }

    @Test
    public void testInstantValueLiteralExtraction() {
        Instant instant = Instant.ofEpochMilli(100L);
        long millis = instant.toEpochMilli();
        int seconds = (int)instant.toEpochMilli() / 1000;
        Assertions.assertThat((Instant)((Instant)new ValueLiteralExpression((Object)millis).getValueAs(Instant.class).orElseThrow(AssertionError::new))).isEqualTo((Object)instant);
        Assertions.assertThat((Instant)((Instant)new ValueLiteralExpression((Object)seconds).getValueAs(Instant.class).orElseThrow(AssertionError::new))).isEqualTo((Object)instant.minusMillis(100L));
    }

    @Test
    public void testOffsetDateTimeValueLiteralExtraction() {
        OffsetDateTime offsetDateTime = OffsetDateTime.of(LocalDateTime.parse("2012-12-12T12:12:12"), ZoneOffset.ofHours(1));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(LocalDateTime.parse("2012-12-12T12:12:12"), ZoneId.of("Europe/Berlin"));
        Assertions.assertThat((OffsetDateTime)((OffsetDateTime)new ValueLiteralExpression((Object)zonedDateTime).getValueAs(OffsetDateTime.class).orElseThrow(AssertionError::new))).isEqualTo((Object)offsetDateTime);
    }

    @Test
    public void testSymbolValueLiteralExtraction() {
        TimeIntervalUnit intervalUnit = TimeIntervalUnit.DAY_TO_MINUTE;
        Assertions.assertThat((Comparable)((Comparable)new ValueLiteralExpression((Object)intervalUnit).getValueAs(TimeIntervalUnit.class).orElseThrow(AssertionError::new))).isEqualTo((Object)intervalUnit);
    }

    @Test
    public void testPeriodValueLiteralExtraction() {
        Integer periodInInt = 10;
        Period expected = Period.ofMonths(10);
        Assertions.assertThat((Period)((Period)new ValueLiteralExpression((Object)periodInInt).getValueAs(Period.class).orElseThrow(AssertionError::new))).isEqualTo((Object)expected);
    }

    private static Expression createExpressionTree(Integer nestedValue) {
        ValueLiteralExpression nestedLiteral = nestedValue != null ? new ValueLiteralExpression((Object)nestedValue, (DataType)DataTypes.INT().notNull()) : new ValueLiteralExpression(null, DataTypes.INT());
        return CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(new ValueLiteralExpression((Object)true), CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(new FieldReferenceExpression("field", DataTypes.INT(), 0, 0), CallExpression.anonymous((FunctionDefinition)new ScalarFunctionDefinition("dummy", DUMMY_FUNCTION), Collections.singletonList(nestedLiteral), (DataType)DataTypes.INT())), (DataType)DataTypes.BOOLEAN())), (DataType)DataTypes.BOOLEAN());
    }
}

