/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.factories.NoMatchingTableFactoryException;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TestTableSinkFactory;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSinkFactoryServiceTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testValidProperties() {
        Map<String, String> props = this.properties();
        Assertions.assertThat((Object)TableFactoryService.find(TableSinkFactory.class, props)).isInstanceOf(TestTableSinkFactory.class);
    }

    @Test
    public void testInvalidContext() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        Map<String, String> props = this.properties();
        props.put("connector.type", "unknown-connector-type");
        TableFactoryService.find(TableSinkFactory.class, props);
    }

    @Test
    public void testDifferentContextVersion() {
        Map<String, String> props = this.properties();
        props.put("connector.property-version", "2");
        Assertions.assertThat((Object)TableFactoryService.find(TableSinkFactory.class, props)).isInstanceOf(TestTableSinkFactory.class);
    }

    @Test
    public void testUnsupportedProperty() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        this.thrown.expectMessage("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nUnsupported property keys:\nformat.path_new");
        Map<String, String> props = this.properties();
        props.put("format.path_new", "/new/path");
        TableFactoryService.find(TableSinkFactory.class, props);
    }

    @Test
    public void testMissingProperty() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        this.thrown.expectMessage("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMissing properties:\nformat.type=test");
        Map<String, String> props = this.properties();
        props.remove("format.type");
        TableFactoryService.find(TableSinkFactory.class, props);
    }

    @Test
    public void testMismatchedProperty() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        this.thrown.expectMessage("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMismatched properties:\n'format.type' expects 'test', but is 'test_new'");
        Map<String, String> props = this.properties();
        props.put("format.type", "test_new");
        TableFactoryService.find(TableSinkFactory.class, props);
    }

    @Test
    public void testMissingAndMismatchedProperty() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        this.thrown.expectMessage("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMissing properties:\nrequired.test=required-0\nMismatched properties:\n'format.type' expects 'test', but is 'test_new'");
        Map<String, String> props = this.properties();
        props.put("format.type", "test_new");
        props.remove("required.test");
        TableFactoryService.find(TableSinkFactory.class, props);
    }

    private Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", "test");
        properties.put("format.type", "test");
        properties.put("required.test", "required-0");
        properties.put("connector.property-version", "1");
        properties.put("format.property-version", "1");
        properties.put("format.path", "/path/to/target");
        properties.put("schema.0.name", "a");
        properties.put("schema.1.name", "b");
        properties.put("schema.2.name", "c");
        properties.put("schema.0.field.0.name", "a");
        properties.put("schema.0.field.1.name", "b");
        properties.put("schema.0.field.2.name", "c");
        return properties;
    }
}

