/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Time;
import java.time.Duration;
import java.time.Period;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.utils.ClassDataTypeConverter;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClassDataTypeConverterTest {
    @Parameterized.Parameter
    public Class<?> clazz;
    @Parameterized.Parameter(value=1)
    @Nullable
    public DataType dataType;

    @Parameterized.Parameters(name="[{index}] class: {0} type: {1}")
    public static List<Object[]> testData() {
        return Arrays.asList({Long.TYPE, ((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)}, {byte[].class, ((DataType)DataTypes.BYTES().nullable()).bridgedTo(byte[].class)}, {Long.class, ((DataType)DataTypes.BIGINT().nullable()).bridgedTo(Long.class)}, {Time.class, ((DataType)DataTypes.TIME((int)0).nullable()).bridgedTo(Time.class)}, {Duration.class, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)9)).bridgedTo(Duration.class)}, {Period.class, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR((int)4), (DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Period.class)}, {BigDecimal.class, null}, {byte[][].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.BYTES().nullable()).bridgedTo(byte[].class))).nullable()).bridgedTo(byte[][].class)}, {Byte[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.TINYINT().nullable()).bridgedTo(Byte.class))).nullable()).bridgedTo(Byte[].class)}, {Byte[][].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.TINYINT().nullable()).bridgedTo(Byte.class))).nullable()).bridgedTo(Byte[].class))).nullable()).bridgedTo(Byte[][].class)}, {Integer[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().nullable()).bridgedTo(Integer.class))).nullable()).bridgedTo(Integer[].class)}, {int[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))).nullable()).bridgedTo(int[].class)}, {TimeIntervalUnit.class, new AtomicDataType((LogicalType)new SymbolType()).bridgedTo(TimeIntervalUnit.class)}, {Row.class, null});
    }

    @Test
    public void testClassToDataTypeConversion() {
        if (this.dataType == null) {
            Assertions.assertThat((Optional)ClassDataTypeConverter.extractDataType(this.clazz)).isEmpty();
        } else {
            Assertions.assertThat((Optional)ClassDataTypeConverter.extractDataType(this.clazz)).contains((Object)this.dataType);
        }
    }
}

