/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypesTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataTypeTest {
    @Test
    public void testNullability() {
        TableAssertions.assertThat((DataType)DataTypes.BIGINT().nullable()).isNullable();
        TableAssertions.assertThat((DataType)DataTypes.BIGINT().notNull()).isNotNullable();
        TableAssertions.assertThat((DataType)((DataType)DataTypes.BIGINT().notNull()).nullable()).isNullable();
    }

    @Test
    public void testAtomicConversion() {
        TableAssertions.assertThat((DataType)DataTypes.TIMESTAMP((int)0).bridgedTo(Timestamp.class)).hasConversionClass(Timestamp.class);
    }

    @Test
    public void testTolerantAtomicConversion() {
        TableAssertions.assertThat((DataType)((DataType)DataTypes.BIGINT().nullable()).bridgedTo(Long.TYPE)).hasConversionClass(Long.TYPE);
    }

    @Test
    public void testInvalidAtomicConversion() {
        Assertions.assertThatThrownBy(() -> {
            DataType cfr_ignored_0 = (DataType)DataTypes.TIMESTAMP((int)0).bridgedTo(DataTypesTest.class);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testArrayElementConversion() {
        TableAssertions.assertThat(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))))).hasConversionClass(int[][].class);
    }

    @Test
    public void testTolerantArrayConversion() {
        TableAssertions.assertThat((DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable()))).bridgedTo(int[][].class)).hasConversionClass(int[][].class);
    }

    @Test
    public void testInvalidArrayConversion() {
        Assertions.assertThatThrownBy(() -> {
            DataType cfr_ignored_0 = (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())).bridgedTo(int[][][].class);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testTolerantMapConversion() {
        TableAssertions.assertThat(DataTypes.MULTISET((DataType)DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE))))).hasConversionClass(Map.class);
    }

    @Test
    public void testFields() {
        TableAssertions.assertThat(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())})).getChildren().containsExactly((Object[])new DataType[]{DataTypes.CHAR((int)2), DataTypes.BOOLEAN()});
    }

    @Test
    public void testInvalidOrderInterval() {
        Assertions.assertThatThrownBy(() -> DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH(), (DataTypes.Resolution)DataTypes.YEAR((int)2))).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testConversionEquality() {
        TableAssertions.assertThat((DataType)DataTypes.VARCHAR((int)2).bridgedTo(String.class)).isEqualTo(DataTypes.VARCHAR((int)2));
    }

    @Test
    public void testArrayInternalElementConversion() {
        TableAssertions.assertThat((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).bridgedTo(ArrayData.class)).getChildren().containsExactly((Object[])new DataType[]{(DataType)DataTypes.STRING().bridgedTo(StringData.class)});
    }

    @Test
    public void testMapInternalElementConversion() {
        TableAssertions.assertThat((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW()).bridgedTo(MapData.class)).getChildren().containsExactly((Object[])new DataType[]{(DataType)DataTypes.STRING().bridgedTo(StringData.class), (DataType)DataTypes.ROW().bridgedTo(RowData.class)});
    }

    @Test
    public void testGetFieldNames() {
        Assertions.assertThat((List)DataType.getFieldNames((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())}))).containsExactly((Object[])new String[]{"c0", "c1", "c2"});
        Assertions.assertThat((List)DataType.getFieldNames((DataType)DataTypes.STRUCTURED(DataTypesTest.SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}))).containsExactly((Object[])new String[]{"name", "count"});
        Assertions.assertThat((List)DataType.getFieldNames((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).isEmpty();
        Assertions.assertThat((List)DataType.getFieldNames((DataType)DataTypes.INT())).isEmpty();
    }

    @Test
    public void testGetFieldDataTypes() {
        Assertions.assertThat((List)DataType.getFieldDataTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())}))).containsExactly((Object[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DOUBLE(), DataTypes.INT()});
        Assertions.assertThat((List)DataType.getFieldDataTypes((DataType)DataTypes.STRUCTURED(DataTypesTest.SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}))).containsExactly((Object[])new DataType[]{DataTypes.STRING(), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)});
        Assertions.assertThat((List)DataType.getFieldDataTypes((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).isEmpty();
        Assertions.assertThat((List)DataType.getFieldDataTypes((DataType)DataTypes.INT())).isEmpty();
    }

    @Test
    public void testGetFieldCount() {
        Assertions.assertThat((int)DataType.getFieldCount((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())}))).isEqualTo(3);
        Assertions.assertThat((int)DataType.getFieldCount((DataType)DataTypes.STRUCTURED(DataTypesTest.SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}))).isEqualTo(2);
        Assertions.assertThat((int)DataType.getFieldCount((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).isZero();
        Assertions.assertThat((int)DataType.getFieldCount((DataType)DataTypes.INT())).isZero();
    }

    @Test
    public void testGetFields() {
        Assertions.assertThat((List)DataType.getFields((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())}))).containsExactly((Object[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())});
        Assertions.assertThat((List)DataType.getFields((DataType)DataTypes.STRUCTURED(DataTypesTest.SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}))).containsExactly((Object[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))});
        Assertions.assertThat((List)DataType.getFields((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).isEmpty();
        Assertions.assertThat((List)DataType.getFields((DataType)DataTypes.INT())).isEmpty();
    }
}

