/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDuplicator;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeDuplicatorTest {
    private static final LogicalTypeDuplicator DUPLICATOR = new LogicalTypeDuplicator();
    private static final LogicalTypeDuplicator INT_REPLACER = new IntReplacer();
    @Parameterized.Parameter
    public LogicalType logicalType;
    @Parameterized.Parameter(value=1)
    public LogicalType replacedLogicalType;

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<Object[]> testData() {
        return Arrays.asList({new CharType(2), new CharType(2)}, {LogicalTypeDuplicatorTest.createMultisetType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createMultisetType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createArrayType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createArrayType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createMapType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createMapType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createRowType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createRowType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createDistinctType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createDistinctType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createUserType((LogicalType)new IntType()), LogicalTypeDuplicatorTest.createUserType((LogicalType)new BigIntType())}, {LogicalTypeDuplicatorTest.createHumanType(), LogicalTypeDuplicatorTest.createHumanType()});
    }

    @Test
    public void testDuplication() {
        Assertions.assertThat((Object)this.logicalType.accept((LogicalTypeVisitor)DUPLICATOR)).isEqualTo((Object)this.logicalType);
    }

    @Test
    public void testReplacement() {
        Assertions.assertThat((Object)this.logicalType.accept((LogicalTypeVisitor)INT_REPLACER)).isEqualTo((Object)this.replacedLogicalType);
    }

    private static MultisetType createMultisetType(LogicalType replacedType) {
        return new MultisetType((LogicalType)new MultisetType(replacedType));
    }

    private static ArrayType createArrayType(LogicalType replacedType) {
        return new ArrayType((LogicalType)new ArrayType(replacedType));
    }

    private static MapType createMapType(LogicalType replacedType) {
        return new MapType(replacedType, (LogicalType)new SmallIntType());
    }

    private static DistinctType createDistinctType(LogicalType replacedType) {
        return new DistinctType.Builder(ObjectIdentifier.of((String)"cat", (String)"db", (String)"Money"), replacedType).description("Money type desc.").build();
    }

    private static RowType createRowType(LogicalType replacedType) {
        return new RowType(Arrays.asList(new RowType.RowField("field1", (LogicalType)new CharType(2)), new RowType.RowField("field2", (LogicalType)new BooleanType()), new RowType.RowField("field3", replacedType)));
    }

    private static StructuredType createHumanType() {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"Human"), Human.class).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("name", (LogicalType)new VarCharType(), "Description."))).description("Human type desc.").setFinal(false).setInstantiable(false).build();
    }

    private static StructuredType createUserType(LogicalType replacedType) {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User"), User.class).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("setting", replacedType))).description("User type desc.").setFinal(false).setInstantiable(true).superType(LogicalTypeDuplicatorTest.createHumanType()).build();
    }

    private static final class User
    extends Human {
        public int setting;

        private User() {
        }
    }

    private static abstract class Human {
        public String name;

        private Human() {
        }
    }

    private static class IntReplacer
    extends LogicalTypeDuplicator {
        private IntReplacer() {
        }

        public LogicalType visit(IntType intType) {
            return new BigIntType();
        }
    }
}

