/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TypeStrategiesTestBase {
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Test
    public void testTypeStrategy() {
        if (this.testSpec.expectedErrorMessage != null) {
            Assertions.assertThatThrownBy(this::runTypeInference).satisfies(FlinkAssertions.anyCauseMatches(ValidationException.class, (String)this.testSpec.expectedErrorMessage));
        } else if (this.testSpec.expectedDataType != null) {
            TableAssertions.assertThat(this.runTypeInference().getOutputDataType()).isEqualTo(this.testSpec.expectedDataType);
        }
    }

    private TypeInferenceUtil.Result runTypeInference() {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = this.testSpec.inputTypes;
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        callContextMock.isGroupedAggregation = this.testSpec.isGroupedAggregation;
        callContextMock.argumentLiterals = IntStream.range(0, this.testSpec.inputTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentValues = IntStream.range(0, this.testSpec.inputTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos ? Optional.ofNullable(this.testSpec.literalValue) : Optional.empty()).collect(Collectors.toList());
        TypeInference typeInference = TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).outputTypeStrategy(this.testSpec.strategy).build();
        return TypeInferenceUtil.runTypeInference((TypeInference)typeInference, (CallContext)callContextMock, null);
    }

    public static class TestSpec {
        @Nullable
        private final String description;
        private final TypeStrategy strategy;
        private List<DataType> inputTypes;
        @Nullable
        private DataType expectedDataType;
        @Nullable
        private String expectedErrorMessage;
        @Nullable
        private Integer literalPos;
        @Nullable
        private Object literalValue;
        private boolean isGroupedAggregation;

        private TestSpec(@Nullable String description, TypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        public static TestSpec forStrategy(TypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        public static TestSpec forStrategy(String description, TypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        public TestSpec inputTypes(DataType ... dataTypes) {
            this.inputTypes = Arrays.asList(dataTypes);
            return this;
        }

        public TestSpec calledWithLiteralAt(int pos, Object value) {
            this.literalPos = pos;
            this.literalValue = value;
            return this;
        }

        public TestSpec calledWithGroupedAggregation() {
            this.isGroupedAggregation = true;
            return this;
        }

        public TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        public TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description != null ? this.description : "";
        }
    }
}

