/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TypeTransformationsTest {
    @Test
    public void testToInternal() {
        DataType dataType = DataTypes.STRUCTURED(SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))});
        DataType expected = (DataType)DataTypes.STRUCTURED(SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)((DataType)DataTypes.STRING().bridgedTo(StringData.class))), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.class)))}).bridgedTo(RowData.class);
        Assertions.assertThat((Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.TO_INTERNAL_CLASS})).isEqualTo((Object)expected);
    }

    @Test
    public void testTimeToSqlTypes() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)DataTypes.TIMESTAMP((int)5)), DataTypes.FIELD((String)"d", (DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.TIME()).bridgedTo(List.class))), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.TIME((int)9))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.TIMESTAMP().bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"d", (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.TIME().bridgedTo(Time.class))).bridgedTo(List.class))), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.DATE().bridgedTo(Date.class)), (DataType)((DataType)DataTypes.TIME((int)9).bridgedTo(Time.class)))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        Assertions.assertThat((Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.timeToSqlTypes()})).isEqualTo((Object)expected);
    }

    @Test
    public void testLegacyRawToTypeInfoRaw() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)TypeTransformationsTest.createLegacyRaw()), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)TypeTransformationsTest.createLegacyRaw()))});
        TypeInformation typeInformation = TypeExtractor.getForClass(TypeTransformationsTest.class);
        AtomicDataType rawDataType = new AtomicDataType((LogicalType)new TypeInformationRawType(typeInformation));
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)rawDataType), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)rawDataType))});
        Assertions.assertThat((Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyRawToTypeInfoRaw()})).isEqualTo((Object)expected);
    }

    @Test
    public void testToNullable() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).notNull())), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.TIME().notNull()))), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.DATE().notNull()), (DataType)((DataType)DataTypes.TIME((int)9).notNull()))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)DataTypes.TIMESTAMP((int)5)), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME())), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.TIME((int)9))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        Assertions.assertThat((Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()})).isEqualTo((Object)expected);
    }

    private static DataType createLegacyRaw() {
        return TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.GENERIC(TypeTransformationsTest.class));
    }

    public static class SimplePojo {
        public final String name;
        public final int count;

        public SimplePojo(String name, int count) {
            this.name = name;
            this.count = count;
        }
    }
}

