/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.runners.Parameterized;

public class CurrentWatermarkInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Arrays.asList(InputTypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP(3) *ROWTIME* works", SpecificInputTypeStrategies.CURRENT_WATERMARK).calledWithArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 3)}).expectArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 3)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP_LTZ(3) *ROWTIME* works", SpecificInputTypeStrategies.CURRENT_WATERMARK).calledWithArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 3)}).expectArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 3)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP(3) doesn't work", SpecificInputTypeStrategies.CURRENT_WATERMARK).calledWithArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeType(TimestampKind.REGULAR, 3)}).expectErrorMessage("The argument of CURRENT_WATERMARK() must be a rowtime attribute, but was 'TIMESTAMP(3) NOT NULL'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP_LTZ(3) doesn't work", SpecificInputTypeStrategies.CURRENT_WATERMARK).calledWithArgumentTypes(new AbstractDataType[]{CurrentWatermarkInputTypeStrategyTest.createRowtimeLtzType(TimestampKind.REGULAR, 3)}).expectErrorMessage("The argument of CURRENT_WATERMARK() must be a rowtime attribute, but was 'TIMESTAMP_LTZ(3) NOT NULL'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("BIGINT doesn't work", SpecificInputTypeStrategies.CURRENT_WATERMARK).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectErrorMessage("CURRENT_WATERMARK() must be called with a single rowtime attribute argument, but 'BIGINT' cannot be a time attribute."));
    }

    private static DataType createRowtimeType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new TimestampType(false, kind, precision));
    }

    private static DataType createRowtimeLtzType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new LocalZonedTimestampType(false, kind, precision));
    }
}

