/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.runners.Parameterized;

public class CurrentWatermarkTypeStrategyTest
extends TypeStrategiesTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TypeStrategiesTestBase.TestSpec> testData() {
        return Arrays.asList(TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP(3) *ROWTIME*", SpecificTypeStrategies.CURRENT_WATERMARK).inputTypes((DataType)CurrentWatermarkTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 3).notNull()).expectDataType(DataTypes.TIMESTAMP((int)3)), TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP_LTZ(3) *ROWTIME*", SpecificTypeStrategies.CURRENT_WATERMARK).inputTypes((DataType)CurrentWatermarkTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 3).notNull()).expectDataType(DataTypes.TIMESTAMP_LTZ((int)3)), TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP(9) *ROWTIME*", SpecificTypeStrategies.CURRENT_WATERMARK).inputTypes((DataType)CurrentWatermarkTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 9).notNull()).expectDataType(DataTypes.TIMESTAMP((int)3)), TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP_LTZ(9) *ROWTIME*", SpecificTypeStrategies.CURRENT_WATERMARK).inputTypes((DataType)CurrentWatermarkTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 9).notNull()).expectDataType(DataTypes.TIMESTAMP_LTZ((int)3)));
    }

    static DataType createRowtimeType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new TimestampType(false, kind, precision));
    }

    static DataType createRowtimeLtzType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new LocalZonedTimestampType(false, kind, precision));
    }
}

