/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils.print;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.table.utils.print.TableauStyle;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TableauStyleTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    @Test
    public void testCharFullWidth() {
        char[] chars = new char[]{'A', 'a', ',', '\u4e2d', '\uff0c', '\u3053'};
        boolean[] expected = new boolean[]{false, false, false, true, true, true};
        for (int i = 0; i < chars.length; ++i) {
            Assertions.assertThat((boolean)TableauStyle.isFullWidth((int)Character.codePointAt(chars, i))).isEqualTo(expected[i]);
        }
    }

    @Test
    public void testStringDisplayWidth() {
        List<String> data = Arrays.asList("abcdefg,12345,ABC", "to be or not to be that's a question.", "\u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587", "\u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f\u3081\u306e\u6587\u3067\u3059");
        int[] expected = new int[]{17, 37, 12, 36};
        for (int i = 0; i < data.size(); ++i) {
            Assertions.assertThat((int)TableauStyle.getStringDisplayWidth((String)data.get(i))).isEqualTo(expected[i]);
        }
    }

    @Test
    public void testPrintWithEmptyResult() {
        PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter()).print(Collections.emptyIterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("Empty set" + System.lineSeparator());
    }

    @Test
    public void testPrintWithEmptyResultAndRowKind() {
        PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter(), (int)30, (boolean)true, (boolean)true).print(Collections.emptyIterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("Empty set" + System.lineSeparator());
    }

    @Test
    public void testPrintWithEmptyResultAndDeriveColumnWidthByContent() {
        PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter(), (int)30, (boolean)true, (boolean)false).print(Collections.emptyIterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("Empty set" + System.lineSeparator());
    }

    @Test
    public void testPrintWithMultipleRows() {
        PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter()).print(this.getData().iterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| boolean |         int |               bigint |                        varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "|  <NULL> |           1 |                    2 |                            abc |        1.23000 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "|   false |      <NULL> |                    0 |                                |        1.00000 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "|    true |  2147483647 |               <NULL> |                        abcdefg |    12345.00000 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "|   false | -2147483648 |  9223372036854775807 |                         <NULL> |    12345.06789 | 2020-03-01 18:39:14.123000 |" + System.lineSeparator() + "|    true |         100 | -9223372036854775808 |                     abcdefg111 |         <NULL> | 2020-03-01 18:39:14.123456 |" + System.lineSeparator() + "|  <NULL> |          -1 |                   -1 | abcdefghijklmnopqrstuvwxyza... |   -12345.06789 |                     <NULL> |" + System.lineSeparator() + "|  <NULL> |          -1 |                   -1 |                   \u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587 |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "|  <NULL> |          -1 |                   -1 |  \u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f... |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "8 rows in set" + System.lineSeparator());
    }

    @Test
    public void testPrintWithMultipleRowsAndRowKind() {
        PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter(), (int)30, (boolean)true, (boolean)true).print(this.getData().iterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| op | boolean |         int |               bigint |                        varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "| +I |         |           1 |                    2 |                            abc |        1.23000 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "| +I |   false |             |                    0 |                                |        1.00000 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "| -D |    true |  2147483647 |                      |                        abcdefg |    12345.00000 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "| +I |   false | -2147483648 |  9223372036854775807 |                                |    12345.06789 | 2020-03-01 18:39:14.123000 |" + System.lineSeparator() + "| +I |    true |         100 | -9223372036854775808 |                     abcdefg111 |                | 2020-03-01 18:39:14.123456 |" + System.lineSeparator() + "| -U |         |          -1 |                   -1 | abcdefghijklmnopqrstuvwxyza... |   -12345.06789 |                            |" + System.lineSeparator() + "| +U |         |          -1 |                   -1 |                   \u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587 |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "| -D |         |          -1 |                   -1 |  \u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f... |   -12345.06789 | 2020-03-04 18:39:14.000000 |" + System.lineSeparator() + "+----+---------+-------------+----------------------+--------------------------------+----------------+----------------------------+" + System.lineSeparator() + "8 rows in set" + System.lineSeparator());
    }

    @Test
    public void testPrintWithMultipleRowsAndDeriveColumnWidthByContent() {
        PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)this.getSchema(), (RowDataToStringConverter)this.getConverter(), (int)30, (boolean)true, (boolean)true).print(this.getData().subList(0, 3).iterator(), new PrintWriter(this.outContent));
        Assertions.assertThat((String)this.outContent.toString()).isEqualTo("+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "| op | boolean |        int | bigint | varchar | decimal(10, 5) |                  timestamp |" + System.lineSeparator() + "+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "| +I |         |          1 |      2 |     abc |        1.23000 | 2020-03-01 18:39:14.000000 |" + System.lineSeparator() + "| +I |   false |            |      0 |         |        1.00000 | 2020-03-01 18:39:14.100000 |" + System.lineSeparator() + "| -D |    true | 2147483647 |        | abcdefg |    12345.00000 | 2020-03-01 18:39:14.120000 |" + System.lineSeparator() + "+----+---------+------------+--------+---------+----------------+----------------------------+" + System.lineSeparator() + "3 rows in set" + System.lineSeparator());
    }

    private ResolvedSchema getSchema() {
        return ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"boolean", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"int", (DataType)DataTypes.INT()), Column.physical((String)"bigint", (DataType)DataTypes.BIGINT()), Column.physical((String)"varchar", (DataType)DataTypes.STRING()), Column.physical((String)"decimal(10, 5)", (DataType)DataTypes.DECIMAL((int)10, (int)5)), Column.physical((String)"timestamp", (DataType)DataTypes.TIMESTAMP((int)6))});
    }

    private RowDataToStringConverter getConverter() {
        return rowData -> {
            String[] results = new String[rowData.getArity()];
            results[0] = rowData.isNullAt(0) ? "<NULL>" : "" + rowData.getBoolean(0);
            results[1] = rowData.isNullAt(1) ? "<NULL>" : "" + rowData.getInt(1);
            results[2] = rowData.isNullAt(2) ? "<NULL>" : "" + rowData.getLong(2);
            results[3] = rowData.isNullAt(3) ? "<NULL>" : rowData.getString(3).toString();
            results[4] = rowData.isNullAt(4) ? "<NULL>" : rowData.getDecimal(4, 10, 5).toString();
            results[5] = rowData.isNullAt(5) ? "<NULL>" : DateTimeUtils.formatTimestamp((TimestampData)rowData.getTimestamp(5, 6), (TimeZone)DateTimeUtils.UTC_ZONE, (int)6);
            return results;
        };
    }

    private List<RowData> getData() {
        ArrayList<Row> data = new ArrayList<Row>();
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null, 1, 2L, "abc", BigDecimal.valueOf(1.23), Timestamp.valueOf("2020-03-01 18:39:14")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{false, null, 0L, "", BigDecimal.valueOf(1L), Timestamp.valueOf("2020-03-01 18:39:14.1")}));
        data.add(Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{true, Integer.MAX_VALUE, null, "abcdefg", BigDecimal.valueOf(12345L), Timestamp.valueOf("2020-03-01 18:39:14.12")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{false, Integer.MIN_VALUE, Long.MAX_VALUE, null, BigDecimal.valueOf(12345.06789), Timestamp.valueOf("2020-03-01 18:39:14.123")}));
        data.add(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, 100, Long.MIN_VALUE, "abcdefg111", null, Timestamp.valueOf("2020-03-01 18:39:14.123456")}));
        data.add(Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{null, -1, -1L, "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz", BigDecimal.valueOf(-12345.06789), null}));
        data.add(Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{null, -1, -1L, "\u8fd9\u662f\u4e00\u6bb5\u4e2d\u6587", BigDecimal.valueOf(-12345.06789), Timestamp.valueOf("2020-03-04 18:39:14")}));
        data.add(Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{null, -1, -1L, "\u3053\u308c\u306f\u65e5\u672c\u8a9e\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f\u3081\u306e\u6587\u3067\u3059", BigDecimal.valueOf(-12345.06789), Timestamp.valueOf("2020-03-04 18:39:14")}));
        return data.stream().map(row -> GenericRowData.ofKind((RowKind)row.getKind(), (Object[])new Object[]{row.getField(0), row.getField(1), row.getField(2), row.getField(3) == null ? null : StringData.fromString((String)((String)row.getFieldAs(3))), row.getField(4) == null ? null : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)row.getFieldAs(4)), (int)10, (int)5), row.getField(5) == null ? null : TimestampData.fromTimestamp((Timestamp)((Timestamp)row.getFieldAs(5)))})).collect(Collectors.toList());
    }
}

