/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.TestManagedTableSink;
import org.apache.flink.table.connector.source.CompactPartition;
import org.apache.flink.table.connector.source.CompactPartitions;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.TestManagedTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ManagedTableFactory;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.types.RowKind;

public class TestManagedTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory,
ManagedTableFactory {
    public static final String ENRICHED_KEY = "ENRICHED_KEY";
    public static final String ENRICHED_VALUE = "ENRICHED_VALUE";
    public static final Map<ObjectIdentifier, AtomicReference<Map<String, String>>> MANAGED_TABLES = new ConcurrentHashMap<ObjectIdentifier, AtomicReference<Map<String, String>>>();
    public static final Map<ObjectIdentifier, AtomicReference<Map<CatalogPartitionSpec, List<Path>>>> MANAGED_TABLE_FILE_ENTRIES = new ConcurrentHashMap<ObjectIdentifier, AtomicReference<Map<CatalogPartitionSpec, List<Path>>>>();
    private static final ConfigOption<String> CHANGELOG_MODE = ConfigOptions.key((String)"changelog-mode").stringType().defaultValue((Object)"I");
    private static final ConfigOption<String> COMPACT_FILE_BASE_PATH = ConfigOptions.key((String)"compact.file-base-path").stringType().defaultValue((Object)"/foo/bar/dir/");
    private static final ConfigOption<List<String>> COMPACT_FILE_ENTRIES = ConfigOptions.key((String)"compact.file-entries").stringType().asList().defaultValues((Object[])new String[0]);

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet configOptions = new HashSet();
        configOptions.add(CHANGELOG_MODE);
        return configOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public Map<String, String> enrichOptions(DynamicTableFactory.Context context) {
        HashMap<String, String> newOptions = new HashMap<String, String>(context.getCatalogTable().getOptions());
        if (MANAGED_TABLES.containsKey(context.getObjectIdentifier())) {
            newOptions.put(ENRICHED_KEY, ENRICHED_VALUE);
        }
        return newOptions;
    }

    public void onCreateTable(DynamicTableFactory.Context context, boolean ignoreIfExists) {
        MANAGED_TABLES.compute(context.getObjectIdentifier(), (k, v) -> {
            if (v != null) {
                if (v.get() == null) {
                    v.set(context.getCatalogTable().getOptions());
                } else if (!ignoreIfExists) {
                    throw new TableException("Table exists.");
                }
            }
            return v;
        });
    }

    public void onDropTable(DynamicTableFactory.Context context, boolean ignoreIfNotExists) {
        AtomicReference<Map<String, String>> reference = MANAGED_TABLES.get(context.getObjectIdentifier());
        if (reference != null) {
            Map previous = reference.getAndSet(null);
            if (!context.getCatalogTable().getOptions().equals(previous) && !ignoreIfNotExists) {
                throw new TableException("Table does not exist.");
            }
        }
    }

    public Map<String, String> onCompactTable(DynamicTableFactory.Context context, CatalogPartitionSpec catalogPartitionSpec) {
        ObjectIdentifier tableIdentifier = context.getObjectIdentifier();
        ResolvedCatalogTable table = context.getCatalogTable();
        HashMap<String, String> newOptions = new HashMap<String, String>(table.getOptions());
        TestManagedTableFactory.resolveCompactFileBasePath(tableIdentifier).ifPresent(s -> newOptions.put(COMPACT_FILE_BASE_PATH.key(), (String)s));
        this.validateAndResolveCompactFileEntries(tableIdentifier, catalogPartitionSpec).ifPresent(s -> newOptions.put(COMPACT_FILE_ENTRIES.key(), (String)s));
        return newOptions;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ChangelogMode changelogMode = TestManagedTableFactory.parseChangelogMode((String)helper.getOptions().get(CHANGELOG_MODE));
        CompactPartitions compactPartitions = CompactPartitions.deserializeCompactPartitions(context.getCatalogTable().getOptions().getOrDefault(COMPACT_FILE_ENTRIES.key(), "")).orElse(CompactPartitions.from(Collections.emptyList()));
        return new TestManagedTableSource(context, compactPartitions, changelogMode);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        String basePath = (String)helper.getOptions().get(COMPACT_FILE_BASE_PATH);
        return new TestManagedTableSink(context, new Path(basePath));
    }

    private static ChangelogMode parseChangelogMode(String string) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        block12: for (String split : string.split(",")) {
            switch (split.trim()) {
                case "I": {
                    builder.addContainedKind(RowKind.INSERT);
                    continue block12;
                }
                case "UB": {
                    builder.addContainedKind(RowKind.UPDATE_BEFORE);
                    continue block12;
                }
                case "UA": {
                    builder.addContainedKind(RowKind.UPDATE_AFTER);
                    continue block12;
                }
                case "D": {
                    builder.addContainedKind(RowKind.DELETE);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ChangelogMode string: " + string);
                }
            }
        }
        return builder.build();
    }

    private static boolean compactedPartition(List<Path> partitionPaths) {
        return partitionPaths != null && partitionPaths.size() == 1 && partitionPaths.get(0).getName().startsWith("compact-");
    }

    private static Optional<String> resolveCompactFileBasePath(ObjectIdentifier tableIdentifier) {
        AtomicReference<Map<CatalogPartitionSpec, List<Path>>> reference = MANAGED_TABLE_FILE_ENTRIES.get(tableIdentifier);
        if (reference != null) {
            Map<CatalogPartitionSpec, List<Path>> managedTableFileEntries = reference.get();
            for (Map.Entry<CatalogPartitionSpec, List<Path>> entry : managedTableFileEntries.entrySet()) {
                List<Path> partitionFiles = entry.getValue();
                if (partitionFiles.size() <= 0) continue;
                Path file = partitionFiles.get(0);
                LinkedHashMap partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)file);
                if (partitionSpec.isEmpty()) {
                    return Optional.of(file.getParent().getPath());
                }
                String tableName = tableIdentifier.asSummaryString();
                int index = file.getPath().indexOf(tableName);
                if (index == -1) continue;
                return Optional.of(file.getPath().substring(0, index + tableName.length()));
            }
        }
        return Optional.empty();
    }

    private Optional<String> validateAndResolveCompactFileEntries(ObjectIdentifier tableIdentifier, CatalogPartitionSpec unresolvedPartitionSpec) {
        AtomicReference<Map<CatalogPartitionSpec, List<Path>>> reference = MANAGED_TABLE_FILE_ENTRIES.get(tableIdentifier);
        if (reference != null) {
            ArrayList resolvedPartitionSpecs = new ArrayList();
            ArrayList<CompactPartition> partitionFilesToCompact = new ArrayList<CompactPartition>();
            reference.get().forEach((resolvedPartitionSpec, partitionPaths) -> {
                if (resolvedPartitionSpec.getPartitionSpec().entrySet().containsAll(unresolvedPartitionSpec.getPartitionSpec().entrySet())) {
                    resolvedPartitionSpecs.add(resolvedPartitionSpec);
                    if (!TestManagedTableFactory.compactedPartition(partitionPaths)) {
                        partitionFilesToCompact.add(CompactPartition.of(resolvedPartitionSpec, partitionPaths));
                    }
                }
            });
            if (resolvedPartitionSpecs.isEmpty()) {
                throw new ValidationException(String.format("Cannot resolve partition spec %s", unresolvedPartitionSpec));
            }
            return CompactPartitions.serializeCompactPartitions(CompactPartitions.from(partitionFilesToCompact));
        }
        return Optional.empty();
    }
}

