/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.module.CoreModule;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class CoreModuleTest {
    CoreModuleTest() {
    }

    @Test
    void testListFunctions() {
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)CoreModule.INSTANCE.listFunctions(false)).contains((Object[])new String[]{"IFNULL"})).doesNotContain((Object[])new String[]{"$REPLICATE_ROWS$1"});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)CoreModule.INSTANCE.listFunctions(true)).contains((Object[])new String[]{"IFNULL"})).contains((Object[])new String[]{"$REPLICATE_ROWS$1"});
    }

    @Test
    void testGetNonExistFunction() {
        Assertions.assertThat((Optional)CoreModule.INSTANCE.getFunctionDefinition("nonexist")).isEmpty();
    }

    @Test
    void testGetFunction() {
        Assertions.assertThat((Optional)CoreModule.INSTANCE.getFunctionDefinition("CAST")).hasValueSatisfying(def -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)def).asInstanceOf(InstanceOfAssertFactories.type(BuiltInFunctionDefinition.class))).extracting(BuiltInFunctionDefinition::getQualifiedName).isEqualTo((Object)"$CAST$1");
        });
    }

    @Test
    void testGetInternalFunction() {
        Assertions.assertThat((Optional)CoreModule.INSTANCE.getFunctionDefinition("$REPLICATE_ROWS$1")).hasValueSatisfying(def -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)def).asInstanceOf(InstanceOfAssertFactories.type(BuiltInFunctionDefinition.class))).satisfies(new ThrowingConsumer[]{builtInDef -> Assertions.assertThat((boolean)builtInDef.isInternal()).isTrue()})).satisfies(new ThrowingConsumer[]{builtInDef -> Assertions.assertThat((String)builtInDef.getQualifiedName()).isEqualTo("$REPLICATE_ROWS$1")});
        });
    }
}

